/*
 * Decompiled with CFR 0.152.
 */
package org.n52.wps.io.data.binding.complex;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.StringWriter;
import org.geotools.feature.FeatureCollection;
import org.n52.wps.io.data.GenericFileData;
import org.n52.wps.io.data.IComplexData;
import org.n52.wps.io.datahandler.generator.SimpleGMLGenerator;
import org.n52.wps.io.datahandler.parser.SimpleGMLParser;

public class GTVectorDataBinding
implements IComplexData {
    protected transient FeatureCollection featureCollection;

    public GTVectorDataBinding(FeatureCollection payload) {
        this.featureCollection = payload;
    }

    @Override
    public Class<FeatureCollection> getSupportedClass() {
        return FeatureCollection.class;
    }

    public FeatureCollection getPayload() {
        return this.featureCollection;
    }

    public File getPayloadAsShpFile() {
        try {
            return GenericFileData.getShpFile(this.featureCollection);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("Could not transform Feature Collection into shp file. Reason " + e.getMessage());
        }
    }

    private synchronized void writeObject(ObjectOutputStream oos) throws IOException {
        StringWriter buffer = new StringWriter();
        SimpleGMLGenerator generator = new SimpleGMLGenerator();
        generator.write(this, buffer);
        oos.writeObject(buffer.toString());
    }

    private synchronized void readObject(ObjectInputStream oos) throws IOException, ClassNotFoundException {
        SimpleGMLParser parser = new SimpleGMLParser();
        ByteArrayInputStream stream = new ByteArrayInputStream(((String)oos.readObject()).getBytes());
        GTVectorDataBinding data = parser.parse(stream, parser.getSupportedFormats()[0], parser.getSupportedEncodings()[0]);
        this.featureCollection = data.getPayload();
    }
}

