/*
 * Decompiled with CFR 0.152.
 */
package org.n52.wps.io;

import java.util.ArrayList;
import java.util.List;
import org.n52.wps.FormatDocument;
import org.n52.wps.PropertyDocument;
import org.n52.wps.io.IOHandler;

public abstract class AbstractIOHandler
implements IOHandler {
    protected List<String> supportedFormats = new ArrayList<String>();
    protected List<String> supportedSchemas = new ArrayList<String>();
    protected List<String> supportedEncodings = new ArrayList<String>();
    protected List<Class<?>> supportedIDataTypes = new ArrayList();
    protected PropertyDocument.Property[] properties;
    protected FormatDocument.Format[] formats;

    @Override
    public boolean isSupportedFormat(String format) {
        for (String f : this.getSupportedFormats()) {
            if (!f.equalsIgnoreCase(format)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String[] getSupportedFormats() {
        String[] resultArray = this.supportedFormats.toArray(new String[this.supportedFormats.size()]);
        return resultArray;
    }

    @Override
    public String[] getSupportedSchemas() {
        String[] resultArray = this.supportedSchemas.toArray(new String[this.supportedSchemas.size()]);
        return resultArray;
    }

    @Override
    public boolean isSupportedSchema(String schema) {
        if (this.supportedSchemas.size() == 0 && schema == null) {
            return true;
        }
        for (String supportedSchema : this.supportedSchemas) {
            if (!supportedSchema.equalsIgnoreCase(schema)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Class<?>[] getSupportedDataBindings() {
        return this.supportedIDataTypes.toArray(new Class[this.supportedIDataTypes.size()]);
    }

    @Override
    public boolean isSupportedDataBinding(Class<?> binding) {
        for (Class<?> currentBinding : this.supportedIDataTypes) {
            if (!binding.equals(currentBinding)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String[] getSupportedEncodings() {
        String[] resultArray = this.supportedEncodings.toArray(new String[this.supportedEncodings.size()]);
        return resultArray;
    }

    @Override
    public FormatDocument.Format[] getSupportedFullFormats() {
        return this.formats;
    }

    @Override
    public boolean isSupportedEncoding(String encoding) {
        for (String currentEncoding : this.getSupportedEncodings()) {
            if (!currentEncoding.equalsIgnoreCase(encoding)) continue;
            return true;
        }
        return false;
    }

    protected boolean isSupportedGenerate(Class<?> binding, String mimeType, String schema) {
        if (!this.isSupportedFormat(mimeType)) {
            return false;
        }
        if (!this.isSupportedSchema(schema)) {
            return false;
        }
        return this.isSupportedDataBinding(binding);
    }
}

