/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.spatial;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import org.geotools.filter.spatial.AbstractPreparedGeometryFilter;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.spatial.Within;

public class WithinImpl
extends AbstractPreparedGeometryFilter
implements Within {
    public WithinImpl(FilterFactory factory, Expression e1, Expression e2) {
        super(factory, e1, e2);
        this.filterType = (short)10;
    }

    public boolean evaluate(Object feature) {
        if (feature instanceof SimpleFeature && !this.validate((SimpleFeature)feature)) {
            return false;
        }
        switch (this.literals) {
            case BOTH: {
                return this.cacheValue;
            }
            case RIGHT: {
                Geometry left = this.getLeftGeometry(feature);
                return this.rightPreppedGeom.contains(left);
            }
            case LEFT: {
                Geometry left = this.leftPreppedGeom.getGeometry();
                Geometry right = this.getRightGeometry(feature);
                return this.basicEvaluate(left, right);
            }
        }
        Geometry left = this.getLeftGeometry(feature);
        Geometry right = this.getRightGeometry(feature);
        return this.basicEvaluate(left, right);
    }

    public Object accept(FilterVisitor visitor, Object extraData) {
        return visitor.visit((Within)this, extraData);
    }

    protected boolean basicEvaluate(Geometry left, Geometry right) {
        Envelope envLeft = left.getEnvelopeInternal();
        Envelope envRight = right.getEnvelopeInternal();
        if (envRight.contains(envLeft)) {
            return left.within(right);
        }
        return false;
    }
}

