/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.visitor.CalcResult;
import org.geotools.feature.visitor.MinVisitor;
import org.geotools.filter.AttributeExpression;
import org.geotools.filter.Expression;
import org.geotools.filter.FunctionExpression;
import org.geotools.filter.FunctionExpressionImpl;
import org.geotools.filter.IllegalFilterException;
import org.geotools.filter.visitor.AbstractFilterVisitor;
import org.geotools.util.logging.Logging;

public class Collection_MinFunction
extends FunctionExpressionImpl
implements FunctionExpression {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.filter.function");
    SimpleFeatureCollection previousFeatureCollection = null;
    Object min = null;

    public Collection_MinFunction() {
        super("Collection_Min");
    }

    public int getArgCount() {
        return 1;
    }

    static CalcResult calculateMin(SimpleFeatureCollection collection, Expression expression) throws IllegalFilterException, IOException {
        MinVisitor minVisitor = new MinVisitor(expression);
        collection.accepts(minVisitor, null);
        return minVisitor.getResult();
    }

    public void setParameters(List args) {
        super.setParameters(args);
        Expression expr = (Expression)this.getExpression(0);
        expr.accept(new AbstractFilterVisitor(){

            public void visit(AttributeExpression expression) {
                String xpath = expression.getAttributePath();
                if (xpath.startsWith("featureMembers/*/")) {
                    xpath = xpath.substring(17);
                } else if (xpath.startsWith("featureMember/*/")) {
                    xpath = xpath.substring(16);
                }
                try {
                    expression.setAttributePath(xpath);
                }
                catch (IllegalFilterException illegalFilterException) {
                    // empty catch block
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object evaluate(Object feature) {
        SimpleFeatureCollection featureCollection;
        if (feature == null) {
            return new Integer(0);
        }
        Expression expr = (Expression)this.getExpression(0);
        SimpleFeatureCollection simpleFeatureCollection = featureCollection = (SimpleFeatureCollection)feature;
        synchronized (simpleFeatureCollection) {
            if (featureCollection != this.previousFeatureCollection) {
                this.previousFeatureCollection = featureCollection;
                this.min = null;
                try {
                    CalcResult result = Collection_MinFunction.calculateMin(featureCollection, expr);
                    if (result != null) {
                        this.min = result.getValue();
                    }
                }
                catch (IllegalFilterException e) {
                    LOGGER.log(Level.FINER, e.getLocalizedMessage(), e);
                }
                catch (IOException e) {
                    LOGGER.log(Level.FINER, e.getLocalizedMessage(), e);
                }
            }
        }
        return this.min;
    }

    public void setExpression(Expression e) {
        this.setParameters(Collections.singletonList(e));
    }
}

