/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import java.awt.geom.AffineTransform;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.referencing.operation.matrix.AffineTransform2D;
import org.geotools.referencing.operation.transform.IdentityTransform;
import org.geotools.referencing.operation.transform.ProjectiveTransform;
import org.geotools.resources.i18n.Errors;
import org.geotools.util.logging.Logging;
import org.opengis.referencing.operation.MathTransform;

public class WorldFileWriter {
    public static final int DEFAULT_BUFFER_SIZE = 4096;
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.data.data");

    private static AffineTransform checkTransform(AffineTransform transform) {
        if (transform == null) {
            throw new IllegalArgumentException(Errors.format((int)143, (Object)"transform"));
        }
        return transform;
    }

    private static MathTransform checkMathTransform(MathTransform transform) {
        if (transform == null) {
            throw new IllegalArgumentException(Errors.format((int)143, (Object)"transform"));
        }
        return transform;
    }

    public WorldFileWriter(File outLocation, AffineTransform transform) throws IOException {
        this(outLocation, (MathTransform)ProjectiveTransform.create((AffineTransform)WorldFileWriter.checkTransform(transform)), 4096);
    }

    public WorldFileWriter(File outLocation, AffineTransform transform, int buffSize) throws IOException {
        this(outLocation, (MathTransform)ProjectiveTransform.create((AffineTransform)WorldFileWriter.checkTransform(transform)), buffSize);
    }

    public WorldFileWriter(OutputStream outLocation, AffineTransform transform) throws IOException {
        this(outLocation, (MathTransform)ProjectiveTransform.create((AffineTransform)WorldFileWriter.checkTransform(transform)));
    }

    public WorldFileWriter(OutputStream outLocation, AffineTransform transform, int buffSize) throws IOException {
        this(outLocation, (MathTransform)ProjectiveTransform.create((AffineTransform)WorldFileWriter.checkTransform(transform)), buffSize);
    }

    public WorldFileWriter(OutputStream outLocation, MathTransform transform) throws IOException {
        this(outLocation, transform, 4096);
    }

    public WorldFileWriter(OutputStream outLocation, MathTransform transform, int buffSize) throws IOException {
        if (outLocation == null) {
            throw new NullPointerException(Errors.format((int)143, (Object)"outLocation"));
        }
        if (transform.getSourceDimensions() != 2 || transform.getTargetDimensions() != 2) {
            throw new IllegalArgumentException(Errors.format((int)94, (Object)"transform", (Object)transform.getSourceDimensions(), (Object)2));
        }
        if (buffSize <= 0) {
            throw new IllegalArgumentException(Errors.format((int)58, (Object)"buffSize", (Object)buffSize));
        }
        this.write(new BufferedWriter(new OutputStreamWriter(outLocation), buffSize), transform);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(BufferedWriter writer, MathTransform transform) {
        try {
            if (transform instanceof IdentityTransform) {
                writer.write("1");
                writer.newLine();
                writer.write("0");
                writer.newLine();
                writer.write("0");
                writer.newLine();
                writer.write("1");
                writer.newLine();
                writer.write("0");
                writer.newLine();
                writer.write("0");
                this.close(writer);
                return;
            }
            if (transform instanceof AffineTransform2D) {
                AffineTransform2D affine = (AffineTransform2D)transform;
                writer.write(Double.toString(affine.getScaleX()));
                writer.newLine();
                writer.write(Double.toString(affine.getShearX()));
                writer.newLine();
                writer.write(Double.toString(affine.getShearY()));
                writer.newLine();
                writer.write(Double.toString(affine.getScaleY()));
                writer.newLine();
                writer.write(Double.toString(affine.getTranslateX()));
                writer.newLine();
                writer.write(Double.toString(affine.getTranslateY()));
                this.close(writer);
                return;
            }
            assert (false) : transform;
        }
        catch (IOException e) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
            }
        }
        finally {
            this.close(writer);
        }
    }

    private void close(BufferedWriter writer) {
        block3: {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (Throwable t) {
                if (!LOGGER.isLoggable(Level.FINE)) break block3;
                LOGGER.log(Level.FINE, t.getLocalizedMessage(), t);
            }
        }
    }

    public WorldFileWriter(File outLocation, MathTransform transform, int buffSize) throws IOException {
        if (outLocation == null) {
            throw new NullPointerException(Errors.format((int)143, (Object)"outLocation"));
        }
        WorldFileWriter.checkMathTransform(transform);
        if (transform.getSourceDimensions() != 2 || transform.getTargetDimensions() != 2) {
            throw new IllegalArgumentException(Errors.format((int)94, (Object)"transform", (Object)transform.getSourceDimensions(), (Object)2));
        }
        if (!outLocation.canWrite() || !outLocation.isFile()) {
            throw new IllegalArgumentException(Errors.format((int)50, (Object)outLocation));
        }
        this.write(new BufferedWriter(new FileWriter(outLocation), buffSize), transform);
    }

    public WorldFileWriter(File outLocation, MathTransform transform) throws IOException {
        this(outLocation, transform, 4096);
    }
}

