/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml3.bindings;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequenceFactory;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import javax.xml.namespace.QName;
import org.geotools.gml3.ArcParameters;
import org.geotools.gml3.Circle;
import org.geotools.gml3.GML;
import org.geotools.gml3.bindings.GML3ParsingUtils;
import org.geotools.xml.AbstractComplexBinding;
import org.geotools.xml.ElementInstance;
import org.geotools.xml.Node;

public class CircleTypeBinding
extends AbstractComplexBinding {
    GeometryFactory gFactory;
    CoordinateSequenceFactory csFactory;
    ArcParameters arcParameters;

    public CircleTypeBinding(GeometryFactory gFactory, CoordinateSequenceFactory csFactory, ArcParameters arcParameters) {
        this.gFactory = gFactory;
        this.csFactory = csFactory;
        this.arcParameters = arcParameters;
    }

    public QName getTarget() {
        return GML.CircleType;
    }

    public Class getType() {
        return LineString.class;
    }

    public int getExecutionMode() {
        return 2;
    }

    public Object parse(ElementInstance instance, Node node, Object value) throws Exception {
        LineString circleLineString = GML3ParsingUtils.lineString(node, this.gFactory, this.csFactory);
        Coordinate[] circleCoordinates = circleLineString.getCoordinates();
        if (circleCoordinates.length != 3) {
            throw new RuntimeException("GML3 parser exception: The number of coordinates of a Circle should be 3. It currently is: " + circleCoordinates.length + "; " + circleLineString);
        }
        Coordinate c1 = circleCoordinates[0];
        Coordinate c2 = circleCoordinates[1];
        Coordinate c3 = circleCoordinates[2];
        Circle circle = new Circle(c1, c2, c3);
        double tolerance = this.arcParameters.getLinearizationTolerance().getTolerance(circle);
        Coordinate[] resultCoordinates = Circle.linearizeCircle(c1, c2, c3, tolerance);
        LineString resultLineString = this.gFactory.createLineString(resultCoordinates);
        return resultLineString;
    }
}

