/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml3.bindings;

import com.vividsolutions.jts.geom.Geometry;
import javax.xml.namespace.QName;
import org.geotools.gml3.GML;
import org.geotools.gml3.bindings.GML3EncodingUtils;
import org.geotools.gml3.bindings.GML3ParsingUtils;
import org.geotools.xml.AbstractComplexBinding;
import org.geotools.xml.ElementInstance;
import org.geotools.xml.Node;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class AbstractGeometryTypeBinding
extends AbstractComplexBinding {
    public QName getTarget() {
        return GML.AbstractGeometryType;
    }

    public Class getType() {
        return Geometry.class;
    }

    public Object parse(ElementInstance instance, Node node, Object value) throws Exception {
        CoordinateReferenceSystem crs;
        if (value instanceof Geometry && (crs = GML3ParsingUtils.crs(node)) != null) {
            Geometry geometry = (Geometry)value;
            geometry.setUserData((Object)crs);
        }
        return value;
    }

    public Object getProperty(Object object, QName name) throws Exception {
        CoordinateReferenceSystem crs;
        Geometry geometry = (Geometry)object;
        if ("srsName".equals(name.getLocalPart()) && (crs = GML3EncodingUtils.getCRS(geometry)) != null) {
            return GML3EncodingUtils.toURI(crs);
        }
        if ("srsDimension".equals(name.getLocalPart()) && (crs = GML3EncodingUtils.getCRS(geometry)) != null) {
            return crs.getCoordinateSystem().getDimension();
        }
        if (GML.id.equals(name)) {
            return GML3EncodingUtils.getID(geometry);
        }
        if (GML.name.equals(name)) {
            return GML3EncodingUtils.getName(geometry);
        }
        if (GML.description.equals(name)) {
            return GML3EncodingUtils.getDescription(geometry);
        }
        return null;
    }
}

