/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.resources;

import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.geotools.resources.Arguments;
import org.geotools.resources.IndexedResourceBundle;
import org.geotools.resources.i18n.Descriptions;
import org.geotools.resources.i18n.Errors;
import org.geotools.resources.i18n.Loggings;
import org.geotools.resources.i18n.Vocabulary;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IndexedResourceCompiler
implements Comparator<Object> {
    private static final File SOURCE_DIRECTORY = new File("/home/aaime/devel/gttrunk/modules/library/metadata/src/main");
    private static final Class<? extends IndexedResourceBundle>[] RESOURCES_TO_PROCESS = new Class[]{Descriptions.class, Vocabulary.class, Loggings.class, Errors.class};
    private static final String PROPERTIES_EXT = ".properties";
    private static final String RESOURCES_EXT = ".utf";
    private static final String ARGUMENT_COUNT_PREFIX = "_$";
    private static final int COMMENT_LENGTH = 92;
    private final File sourceDirectory;
    private final Map<Integer, String> allocatedIDs = new HashMap<Integer, String>();
    private final Map<Object, Object> resources = new HashMap<Object, Object>();
    private final PrintWriter out;

    private IndexedResourceCompiler(File sourceDirectory, Class<? extends IndexedResourceBundle> bundleClass, boolean renumber, PrintWriter out) throws IOException {
        this.sourceDirectory = sourceDirectory;
        this.out = out;
        if (!renumber) {
            try {
                String classname = IndexedResourceCompiler.toKeyClass(bundleClass.getName());
                AccessibleObject[] fields = Class.forName(classname).getFields();
                out.print("Loading ");
                out.println(classname);
                Field.setAccessible(fields, true);
                int i = fields.length;
                while (--i >= 0) {
                    AccessibleObject field = fields[i];
                    String key = ((Field)field).getName();
                    try {
                        Object ID = ((Field)field).get(null);
                        if (!(ID instanceof Integer)) continue;
                        this.allocatedIDs.put((Integer)ID, key);
                    }
                    catch (IllegalAccessException exception) {
                        File source = new File(classname.replace('.', '/') + ".class");
                        this.warning(source, key, "Access denied", exception);
                    }
                }
            }
            catch (ClassNotFoundException exception) {
                // empty catch block
            }
        }
    }

    private static String toKeyClass(String bundleClass) {
        if (bundleClass.endsWith("s")) {
            bundleClass = bundleClass.substring(0, bundleClass.length() - 1);
        }
        return bundleClass + "Keys";
    }

    private static Properties loadPropertyFile(File file) throws IOException {
        FileInputStream input = new FileInputStream(file);
        Properties properties = new Properties();
        properties.load(input);
        ((InputStream)input).close();
        return properties;
    }

    private void processPropertyFile(File file) throws IOException {
        Properties properties = IndexedResourceCompiler.loadPropertyFile(file);
        this.resources.clear();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            int expected;
            int argumentCount;
            MessageFormat message;
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (key.trim().length() == 0) {
                this.warning(file, key, "Empty key.", null);
                continue;
            }
            if (value.trim().length() == 0) {
                this.warning(file, key, "Empty value.", null);
                continue;
            }
            try {
                message = new MessageFormat(IndexedResourceCompiler.toMessageFormatString(value));
            }
            catch (IllegalArgumentException exception) {
                this.warning(file, key, "Bad resource value", exception);
                continue;
            }
            int index = key.lastIndexOf(ARGUMENT_COUNT_PREFIX);
            if (index < 0) {
                argumentCount = 0;
                this.resources.put(key, value);
            } else {
                try {
                    String suffix = key.substring(index + ARGUMENT_COUNT_PREFIX.length());
                    argumentCount = Integer.parseInt(suffix);
                    this.resources.put(key, message.toPattern());
                }
                catch (NumberFormatException exception) {
                    this.warning(file, key, "Bad number in resource key", exception);
                    continue;
                }
            }
            if (argumentCount == (expected = message.getFormats().length)) continue;
            String suffix = ARGUMENT_COUNT_PREFIX + expected;
            this.warning(file, key, "Key name should ends with \"" + suffix + "\".", null);
        }
        String[] keys = this.resources.keySet().toArray(new String[this.resources.size()]);
        Arrays.sort(keys, this);
        int freeID = 0;
        for (int i = 0; i < keys.length; ++i) {
            Integer ID;
            String key = keys[i];
            if (this.allocatedIDs.containsValue(key)) continue;
            while (this.allocatedIDs.containsKey(ID = Integer.valueOf(freeID++))) {
            }
            this.allocatedIDs.put(ID, key);
        }
    }

    private void writeUTFFile(File file) throws IOException {
        int count = this.allocatedIDs.isEmpty() ? 0 : Collections.max(this.allocatedIDs.keySet()) + 1;
        DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
        out.writeInt(count);
        for (int i = 0; i < count; ++i) {
            String value = (String)this.resources.get(this.allocatedIDs.get(i));
            out.writeUTF(value != null ? value : "");
        }
        out.close();
    }

    private static String toMessageFormatString(String text) {
        int level = 0;
        int last = -1;
        StringBuilder buffer = new StringBuilder(text);
        block9: for (int i = 0; i < buffer.length(); ++i) {
            switch (buffer.charAt(i)) {
                case '{': {
                    ++level;
                    last = i;
                    continue block9;
                }
                case '}': {
                    --level;
                    last = i;
                    continue block9;
                }
                case '\'': {
                    if (i + 2 < buffer.length() && buffer.charAt(i + 2) == '\'') {
                        switch (buffer.charAt(i + 1)) {
                            case '{': {
                                i += 2;
                                continue block9;
                            }
                            case '}': {
                                i += 2;
                                continue block9;
                            }
                        }
                    }
                    if (level <= 0) {
                        buffer.insert(i++, '\'');
                        continue block9;
                    }
                    if (last < 0 || buffer.charAt(last) != '{') continue block9;
                    int scan = last;
                    while (scan < i) {
                        if (Character.isDigit(buffer.charAt(++scan))) continue;
                        String choice = ",choice,";
                        int end = scan + ",choice,".length();
                        if (end >= buffer.length() || !buffer.substring(scan, end).equalsIgnoreCase(",choice,")) continue block9;
                        buffer.insert(i++, '\'');
                        continue block9;
                    }
                    continue block9;
                }
            }
        }
        return buffer.toString();
    }

    private void warning(File file, String key, String message, Exception exception) {
        this.out.print("ERROR ");
        if (file != null) {
            String filename = file.getPath();
            if (filename.endsWith(PROPERTIES_EXT)) {
                filename = filename.substring(0, filename.length() - PROPERTIES_EXT.length());
            }
            this.out.print('(');
            this.out.print(filename);
            this.out.print(')');
        }
        this.out.print(": ");
        if (key != null) {
            this.out.print('\"');
            this.out.print(key);
            this.out.print('\"');
        }
        this.out.println();
        this.out.print(message);
        if (exception != null) {
            this.out.print(": ");
            this.out.print(exception.getLocalizedMessage());
        }
        this.out.println();
        this.out.println();
        this.out.flush();
    }

    private void writeJavaSource(Class bundleClass) throws IOException {
        String fullname = IndexedResourceCompiler.toKeyClass(bundleClass.getName());
        int packageEnd = fullname.lastIndexOf(46);
        String packageName = fullname.substring(0, packageEnd);
        String classname = fullname.substring(packageEnd + 1);
        File file = new File(this.sourceDirectory, "java/" + fullname.replace('.', '/') + ".java");
        if (!file.getParentFile().isDirectory()) {
            this.warning(file, null, "Parent directory not found.", null);
            return;
        }
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
        out.write("/*\n *    GeoTools - The Open Source Java GIS Toolkit\n *    http://geotools.org\n *    \n *    (C) 2003-2008, Open Source Geospatial Foundation (OSGeo)\n *    \n *    This library is free software; you can redistribute it and/or\n *    modify it under the terms of the GNU Lesser General Public\n *    License as published by the Free Software Foundation;\n *    version 2.1 of the License.\n *    \n *    This library is distributed in the hope that it will be useful,\n *    but WITHOUT ANY WARRANTY; without even the implied warranty of\n *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU\n *    Lesser General Public License for more details.\n *    \n *    THIS IS AN AUTOMATICALLY GENERATED FILE. DO NOT EDIT!\n *    Generated with: org.geotools.resources.IndexedResourceCompiler\n */\n");
        out.write("package ");
        out.write(packageName);
        out.write(";\n\n\n");
        out.write("/**\n * Resource keys. This class is used when compiling sources, but\n * no dependencies to {@code ResourceKeys} should appear in any\n * resulting class files.  Since Java compiler inlines final integer\n * values, using long identifiers will not bloat constant pools of\n * classes compiled against the interface, provided that no class\n * implements this interface.\n *\n * @see org.geotools.resources.IndexedResourceBundle\n * @see org.geotools.resources.IndexedResourceCompiler\n * @source $URL$\n */\n");
        out.write("public final class ");
        out.write(classname);
        out.write(" {\n");
        out.write("    private ");
        out.write(classname);
        out.write("() {\n");
        out.write("    }\n");
        Map.Entry[] entries = this.allocatedIDs.entrySet().toArray(new Map.Entry[this.allocatedIDs.size()]);
        Arrays.sort(entries, this);
        for (int i = 0; i < entries.length; ++i) {
            out.write(10);
            String key = (String)entries[i].getValue();
            String ID = entries[i].getKey().toString();
            String message = (String)this.resources.get(key);
            if (message != null) {
                out.write("    /**\n");
                while ((message = message.trim()).length() != 0) {
                    out.write("     * ");
                    int stop = message.length();
                    if (stop > 92) {
                        for (stop = 92; stop > 20 && !Character.isWhitespace(message.charAt(stop)); --stop) {
                        }
                    }
                    out.write(message.substring(0, stop).trim());
                    out.write(10);
                    message = message.substring(stop);
                }
                out.write("     */\n");
            }
            out.write("    public static final int ");
            out.write(key);
            out.write(" = ");
            out.write(ID);
            out.write(";\n");
        }
        out.write("}\n");
        out.close();
    }

    @Override
    public int compare(Object o1, Object o2) {
        if (o1 instanceof Map.Entry) {
            o1 = ((Map.Entry)o1).getValue();
        }
        if (o2 instanceof Map.Entry) {
            o2 = ((Map.Entry)o2).getValue();
        }
        String key1 = (String)o1;
        String key2 = (String)o2;
        return key1.compareTo(key2);
    }

    private static void scanForResources(File sourceDirectory, Class<? extends IndexedResourceBundle> bundleClass, boolean renumber, PrintWriter out) throws IOException {
        String fullname = bundleClass.getName();
        int packageEnd = fullname.lastIndexOf(46);
        String packageName = fullname.substring(0, packageEnd);
        String classname = fullname.substring(packageEnd + 1);
        String packageDir = packageName.replace('.', '/');
        File srcDir = new File(sourceDirectory, "java/" + packageDir);
        File utfDir = new File(sourceDirectory, "resources/" + packageDir);
        if (!srcDir.isDirectory()) {
            out.print('\"');
            out.print(srcDir.getPath());
            out.println("\" is not a directory.");
            return;
        }
        if (!utfDir.isDirectory()) {
            out.print('\"');
            out.print(utfDir.getPath());
            out.println("\" is not a directory.");
            return;
        }
        IndexedResourceCompiler compiler = null;
        File[] content = srcDir.listFiles();
        File defaultLanguage = null;
        for (int i = 0; i < content.length; ++i) {
            File file = content[i];
            String filename = file.getName();
            if (!filename.startsWith(classname) || !filename.endsWith(PROPERTIES_EXT)) continue;
            if (compiler == null) {
                compiler = new IndexedResourceCompiler(sourceDirectory, bundleClass, renumber, out);
            }
            compiler.processPropertyFile(file);
            String noExt = filename.substring(0, filename.length() - PROPERTIES_EXT.length());
            File utfFile = new File(utfDir, noExt + RESOURCES_EXT);
            compiler.writeUTFFile(utfFile);
            if (!noExt.equals(classname)) continue;
            defaultLanguage = file;
        }
        if (compiler != null) {
            if (defaultLanguage != null) {
                compiler.resources.clear();
                compiler.resources.putAll(IndexedResourceCompiler.loadPropertyFile(defaultLanguage));
            }
            super.writeJavaSource(bundleClass);
        }
    }

    public static void main(String[] args, File sourceDirectory, Class<? extends IndexedResourceBundle>[] resourcesToProcess) {
        Arguments arguments = new Arguments(args);
        boolean renumber = arguments.getFlag("-renumber");
        PrintWriter out = arguments.out;
        args = arguments.getRemainingArguments(0);
        if (!sourceDirectory.isDirectory()) {
            out.print(sourceDirectory);
            out.println(" not found or is not a directory.");
            return;
        }
        for (int i = 0; i < resourcesToProcess.length; ++i) {
            try {
                IndexedResourceCompiler.scanForResources(sourceDirectory, resourcesToProcess[i], renumber, out);
                continue;
            }
            catch (IOException exception) {
                out.println(exception.getLocalizedMessage());
            }
        }
        out.flush();
    }

    public static void main(String[] args) {
        IndexedResourceCompiler.main(args, SOURCE_DIRECTORY, RESOURCES_TO_PROCESS);
    }
}

