/*
 * Decompiled with CFR 0.152.
 */
package org.n52.wps.client;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import net.opengis.ows.x11.ExceptionReportDocument;
import net.opengis.wps.x100.DocumentOutputDefinitionType;
import net.opengis.wps.x100.ExecuteDocument;
import net.opengis.wps.x100.ExecuteResponseDocument;
import net.opengis.wps.x100.OutputDataType;
import net.opengis.wps.x100.OutputDescriptionType;
import net.opengis.wps.x100.ProcessDescriptionType;
import org.n52.wps.client.StaticDataHandlerRepository;
import org.n52.wps.client.WPSClientException;
import org.n52.wps.io.IParser;
import org.n52.wps.io.data.IData;

public class ExecuteResponseAnalyser {
    ProcessDescriptionType processDesc;
    ExecuteDocument exec;
    Object response;

    public ExecuteResponseAnalyser(ExecuteDocument exec, Object response, ProcessDescriptionType processDesc) throws WPSClientException {
        this.processDesc = processDesc;
        this.exec = exec;
        if (response instanceof ExceptionReportDocument.ExceptionReport) {
            throw new WPSClientException("Output is not ComplexData but an Exception Report");
        }
        this.response = response;
    }

    public IData getComplexData(String outputID, Class binding) throws WPSClientException {
        return this.parseProcessOutput(outputID, binding);
    }

    public IData getComplexDataByIndex(int index, Class binding) throws WPSClientException {
        ExecuteResponseDocument doc = null;
        if (!(this.response instanceof ExecuteResponseDocument)) {
            throw new WPSClientException("Output cannot be determined by index since it is either raw data or an exception report");
        }
        doc = (ExecuteResponseDocument)this.response;
        OutputDataType[] outputs = doc.getExecuteResponse().getProcessOutputs().getOutputArray();
        int counter = 0;
        for (OutputDataType output : outputs) {
            if (output.getData().getComplexData() == null) continue;
            if (counter == index) {
                return this.parseProcessOutput(output.getIdentifier().getStringValue(), binding);
            }
            ++counter;
        }
        return null;
    }

    public String getComplexReferenceByIndex(int index) throws WPSClientException {
        ExecuteResponseDocument doc = null;
        if (!(this.response instanceof ExecuteResponseDocument)) {
            throw new WPSClientException("Output cannot be determined by index since it is either raw data or an exception report");
        }
        doc = (ExecuteResponseDocument)this.response;
        OutputDataType[] outputs = doc.getExecuteResponse().getProcessOutputs().getOutputArray();
        int counter = 0;
        for (OutputDataType output : outputs) {
            if (output.getReference() == null) continue;
            if (counter == index) {
                return output.getReference().getHref();
            }
            ++counter;
        }
        throw new RuntimeException("No reference found in response");
    }

    private IData parseProcessOutput(String outputID, Class outputDataBindingClass) throws WPSClientException {
        OutputDescriptionType outputDesc = null;
        String schema = null;
        String mimeType = null;
        String encoding = null;
        if (this.exec.getExecute().isSetResponseForm() && this.exec.getExecute().getResponseForm().isSetRawDataOutput()) {
            schema = this.exec.getExecute().getResponseForm().getRawDataOutput().getSchema();
            mimeType = this.exec.getExecute().getResponseForm().getRawDataOutput().getMimeType();
            encoding = this.exec.getExecute().getResponseForm().getRawDataOutput().getEncoding();
        } else if (this.exec.getExecute().isSetResponseForm() && this.exec.getExecute().getResponseForm().isSetResponseDocument()) {
            DocumentOutputDefinitionType[] outputs;
            for (DocumentOutputDefinitionType output : outputs = this.exec.getExecute().getResponseForm().getResponseDocument().getOutputArray()) {
                if (!output.getIdentifier().getStringValue().equals(outputID)) continue;
                schema = output.getSchema();
                mimeType = output.getMimeType();
                encoding = output.getEncoding();
            }
        }
        if (mimeType == null) {
            for (OutputDescriptionType tempDesc : this.processDesc.getProcessOutputs().getOutputArray()) {
                if (!outputID.equals(tempDesc.getIdentifier().getStringValue())) continue;
                outputDesc = tempDesc;
                break;
            }
            mimeType = outputDesc.getComplexOutput().getDefault().getFormat().getMimeType();
            encoding = outputDesc.getComplexOutput().getDefault().getFormat().getEncoding();
            schema = outputDesc.getComplexOutput().getDefault().getFormat().getSchema();
        }
        IParser parser = StaticDataHandlerRepository.getParserFactory().getParser(schema, mimeType, encoding, outputDataBindingClass);
        InputStream is = null;
        if (this.response instanceof InputStream) {
            is = (InputStream)this.response;
        } else if (this.response instanceof ExecuteResponseDocument) {
            OutputDataType[] processOutputs;
            ExecuteResponseDocument responseDocument = (ExecuteResponseDocument)this.response;
            for (OutputDataType processOutput : processOutputs = responseDocument.getExecuteResponse().getProcessOutputs().getOutputArray()) {
                if (!processOutput.getIdentifier().getStringValue().equalsIgnoreCase(outputID)) continue;
                if (processOutput.isSetReference()) {
                    String urlString = processOutput.getReference().getHref();
                    try {
                        URL url = new URL(urlString);
                        is = url.openStream();
                        continue;
                    }
                    catch (MalformedURLException e) {
                        throw new WPSClientException("Could not fetch response from referenced URL", e);
                    }
                    catch (IOException e) {
                        throw new WPSClientException("Could not fetch response from referenced URL", e);
                    }
                }
                is = processOutput.getData().getComplexData().newInputStream();
            }
        } else {
            throw new WPSClientException("Wrong output type");
        }
        if (parser != null) {
            if (encoding.equalsIgnoreCase("base64")) {
                return parser.parseBase64(is, mimeType, schema);
            }
            return parser.parse(is, mimeType, schema);
        }
        throw new RuntimeException("Could not find suitable parser");
    }
}

