/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.processing;

import java.io.Serializable;
import org.geotools.coverage.processing.CoverageProcessingException;
import org.geotools.factory.Hints;
import org.geotools.resources.Classes;
import org.geotools.util.Utilities;
import org.opengis.coverage.Coverage;
import org.opengis.coverage.processing.Operation;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.util.InternationalString;

public abstract class AbstractOperation
implements Operation,
Serializable {
    private static final long serialVersionUID = -1441856042779942954L;
    protected final ParameterDescriptorGroup descriptor;

    public AbstractOperation(ParameterDescriptorGroup descriptor) {
        Utilities.ensureNonNull((String)"descriptor", (Object)descriptor);
        this.descriptor = descriptor;
    }

    public String getName() {
        return this.descriptor.getName().getCode();
    }

    @Deprecated
    public String getDescription() {
        InternationalString remarks = this.descriptor.getRemarks();
        return remarks != null ? remarks.toString() : null;
    }

    @Deprecated
    public String getDocURL() {
        return null;
    }

    @Deprecated
    public String getVersion() {
        return this.descriptor.getName().getVersion();
    }

    @Deprecated
    public String getVendor() {
        return "Geotools 2";
    }

    public int getNumSources() {
        return AbstractOperation.getNumSources(this.descriptor);
    }

    private static int getNumSources(ParameterDescriptorGroup descriptor) {
        int count = 0;
        for (GeneralParameterDescriptor candidate : descriptor.descriptors()) {
            Class type;
            if (candidate instanceof ParameterDescriptorGroup) {
                count += AbstractOperation.getNumSources((ParameterDescriptorGroup)candidate);
                continue;
            }
            if (!(candidate instanceof ParameterDescriptor) || !Coverage.class.isAssignableFrom(type = ((ParameterDescriptor)candidate).getValueClass())) continue;
            ++count;
        }
        return count;
    }

    public ParameterValueGroup getParameters() {
        return this.descriptor.createValue();
    }

    public abstract Coverage doOperation(ParameterValueGroup var1, Hints var2) throws CoverageProcessingException;

    public int hashCode() {
        return this.descriptor.hashCode() ^ 0x80D9DFD6;
    }

    public boolean equals(Object object) {
        if (object != null && object.getClass().equals(this.getClass())) {
            AbstractOperation that = (AbstractOperation)object;
            return Utilities.equals((Object)this.descriptor, (Object)that.descriptor);
        }
        return false;
    }

    public String toString() {
        return Classes.getShortClassName((Object)this) + '[' + this.getName() + ']';
    }
}

