/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.ows;

import java.io.IOException;
import java.io.InputStream;
import org.geotools.data.ows.HTTPResponse;
import org.geotools.data.ows.ServiceExceptionParser;
import org.geotools.ows.ServiceException;
import org.jdom.JDOMException;

public abstract class Response {
    protected HTTPResponse httpResponse;

    public Response(HTTPResponse httpResponse) throws ServiceException, IOException {
        if (httpResponse.getResponseStream() == null) {
            throw new NullPointerException("An inputStream is required for " + this.getClass().getName());
        }
        if (httpResponse.getContentType() == null) {
            throw new NullPointerException("Content type is required for " + this.getClass().getName());
        }
        this.httpResponse = httpResponse;
        if (httpResponse.getContentType().toLowerCase().equals("application/vnd.ogc.se_xml")) {
            try {
                throw this.parseException(httpResponse.getResponseStream());
            }
            catch (Throwable throwable) {
                this.dispose();
                throw throwable;
            }
        }
    }

    public void dispose() {
        this.httpResponse.dispose();
    }

    public String getContentType() {
        return this.httpResponse.getContentType();
    }

    public InputStream getInputStream() {
        try {
            return this.httpResponse.getResponseStream();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected ServiceException parseException(InputStream inputStream) throws IOException {
        try {
            ServiceException serviceException = ServiceExceptionParser.parse(inputStream);
            return serviceException;
        }
        catch (JDOMException e) {
            throw (IOException)new IOException().initCause(e);
        }
        finally {
            inputStream.close();
        }
    }
}

