/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory;

import java.awt.RenderingHints;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.measure.unit.Unit;
import org.geotools.factory.AbstractFactory;
import org.geotools.factory.Factory;
import org.geotools.factory.FactoryRegistryException;
import org.geotools.factory.Hints;
import org.geotools.factory.OptionalFactory;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.CRS;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.geotools.referencing.factory.AbstractAuthorityFactory;
import org.geotools.referencing.factory.DirectAuthorityFactory;
import org.geotools.referencing.factory.IdentifiedObjectFinder;
import org.geotools.referencing.factory.ReferencingFactoryContainer;
import org.geotools.resources.i18n.Errors;
import org.geotools.resources.i18n.Loggings;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.extent.Extent;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.referencing.AuthorityFactory;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.DerivedCRS;
import org.opengis.referencing.crs.EngineeringCRS;
import org.opengis.referencing.crs.GeocentricCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ImageCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.CSAuthorityFactory;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.CylindricalCS;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.cs.PolarCS;
import org.opengis.referencing.cs.SphericalCS;
import org.opengis.referencing.cs.TimeCS;
import org.opengis.referencing.cs.VerticalCS;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.DatumAuthorityFactory;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.EngineeringDatum;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.ImageDatum;
import org.opengis.referencing.datum.PrimeMeridian;
import org.opengis.referencing.datum.TemporalDatum;
import org.opengis.referencing.datum.VerticalDatum;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.CoordinateOperationAuthorityFactory;
import org.opengis.referencing.operation.CoordinateOperationFactory;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.util.InternationalString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthorityFactoryAdapter
extends AbstractAuthorityFactory
implements OptionalFactory {
    private static final Hints.Key[] TYPES = new Hints.Key[]{Hints.CRS_AUTHORITY_FACTORY, Hints.CS_AUTHORITY_FACTORY, Hints.DATUM_AUTHORITY_FACTORY, Hints.COORDINATE_OPERATION_AUTHORITY_FACTORY};
    final DatumAuthorityFactory datumFactory;
    final CSAuthorityFactory csFactory;
    final CRSAuthorityFactory crsFactory;
    final CoordinateOperationAuthorityFactory operationFactory;
    private transient ReferencingFactoryContainer factories;

    AuthorityFactoryAdapter(int priority) {
        super(priority);
        this.datumFactory = null;
        this.csFactory = null;
        this.crsFactory = null;
        this.operationFactory = null;
    }

    protected AuthorityFactoryAdapter(AuthorityFactory factory) {
        this(factory, null);
    }

    AuthorityFactoryAdapter(AuthorityFactory factory, AuthorityFactory fallback) {
        this((CRSAuthorityFactory)(factory instanceof CRSAuthorityFactory ? (CRSAuthorityFactory)factory : (fallback instanceof CRSAuthorityFactory ? (CRSAuthorityFactory)fallback : null)), (CSAuthorityFactory)(factory instanceof CSAuthorityFactory ? (CSAuthorityFactory)factory : (fallback instanceof CSAuthorityFactory ? (CSAuthorityFactory)fallback : null)), (DatumAuthorityFactory)(factory instanceof DatumAuthorityFactory ? (DatumAuthorityFactory)factory : (fallback instanceof DatumAuthorityFactory ? (DatumAuthorityFactory)fallback : null)), (CoordinateOperationAuthorityFactory)(factory instanceof CoordinateOperationAuthorityFactory ? (CoordinateOperationAuthorityFactory)factory : (fallback instanceof CoordinateOperationAuthorityFactory ? (CoordinateOperationAuthorityFactory)fallback : null)));
    }

    protected AuthorityFactoryAdapter(CRSAuthorityFactory crsFactory, CSAuthorityFactory csFactory, DatumAuthorityFactory datumFactory, CoordinateOperationAuthorityFactory opFactory) {
        super(Math.max(AuthorityFactoryAdapter.getPriority((AuthorityFactory)datumFactory), Math.max(AuthorityFactoryAdapter.getPriority((AuthorityFactory)csFactory), Math.max(AuthorityFactoryAdapter.getPriority((AuthorityFactory)crsFactory), AuthorityFactoryAdapter.getPriority((AuthorityFactory)opFactory)))));
        if (this instanceof CRSAuthorityFactory) {
            AuthorityFactoryAdapter.ensureNonNull("crsFactory", crsFactory);
        }
        if (this instanceof CSAuthorityFactory) {
            AuthorityFactoryAdapter.ensureNonNull("csFactory", csFactory);
        }
        if (this instanceof DatumAuthorityFactory) {
            AuthorityFactoryAdapter.ensureNonNull("datumFactory", datumFactory);
        }
        if (this instanceof CoordinateOperationAuthorityFactory) {
            AuthorityFactoryAdapter.ensureNonNull("opFactory", opFactory);
        }
        this.datumFactory = datumFactory;
        this.store((Hints.Key)Hints.DATUM_AUTHORITY_FACTORY, (AuthorityFactory)this.datumFactory);
        this.csFactory = csFactory;
        this.store((Hints.Key)Hints.CS_AUTHORITY_FACTORY, (AuthorityFactory)this.csFactory);
        this.crsFactory = crsFactory;
        this.store((Hints.Key)Hints.CRS_AUTHORITY_FACTORY, (AuthorityFactory)this.crsFactory);
        this.operationFactory = opFactory;
        this.store((Hints.Key)Hints.COORDINATE_OPERATION_AUTHORITY_FACTORY, (AuthorityFactory)this.operationFactory);
    }

    private static int getPriority(AuthorityFactory factory) {
        return factory instanceof AbstractFactory ? ((AbstractFactory)factory).getPriority() : 50;
    }

    private void store(Hints.Key key, AuthorityFactory factory) {
        if (factory != null && this.hints.put(key, factory) != null) {
            throw new AssertionError(key);
        }
    }

    protected AuthorityFactoryAdapter(String authority, Hints userHints) throws FactoryRegistryException {
        this(ReferencingFactoryFinder.getCRSAuthorityFactory(authority, AuthorityFactoryAdapter.trim(userHints, (Hints.Key)Hints.CRS_AUTHORITY_FACTORY)), ReferencingFactoryFinder.getCSAuthorityFactory(authority, AuthorityFactoryAdapter.trim(userHints, (Hints.Key)Hints.CS_AUTHORITY_FACTORY)), ReferencingFactoryFinder.getDatumAuthorityFactory(authority, AuthorityFactoryAdapter.trim(userHints, (Hints.Key)Hints.DATUM_AUTHORITY_FACTORY)), ReferencingFactoryFinder.getCoordinateOperationAuthorityFactory(authority, AuthorityFactoryAdapter.trim(userHints, (Hints.Key)Hints.COORDINATE_OPERATION_AUTHORITY_FACTORY)));
    }

    private static Hints trim(Hints userHints, Hints.Key keep) {
        Hints reduced = userHints;
        if (userHints != null) {
            for (int i = 0; i < TYPES.length; ++i) {
                Hints.Key key = TYPES[i];
                if (keep.equals((Object)key)) continue;
                if (reduced == userHints) {
                    if (!userHints.containsKey((Object)key)) continue;
                    reduced = new Hints((RenderingHints)userHints);
                }
                reduced.remove((Object)key);
            }
        }
        return reduced;
    }

    private Hints hints() {
        Hints extended = new Hints(this.hints);
        AuthorityFactoryAdapter.addAll((AuthorityFactory)this.operationFactory, extended);
        AuthorityFactoryAdapter.addAll((AuthorityFactory)this.datumFactory, extended);
        AuthorityFactoryAdapter.addAll((AuthorityFactory)this.csFactory, extended);
        AuthorityFactoryAdapter.addAll((AuthorityFactory)this.crsFactory, extended);
        extended.putAll(this.hints);
        return extended;
    }

    private static void addAll(AuthorityFactory factory, Hints hints) {
        if (factory instanceof Factory) {
            hints.putAll(((Factory)factory).getImplementationHints());
        }
    }

    @Override
    Collection<? super AuthorityFactory> dependencies() {
        Object factory;
        ArrayList<AuthorityFactory> dep = new ArrayList<AuthorityFactory>(4);
        try {
            factory = this.getAuthorityFactory(null);
        }
        catch (FactoryException e) {
            factory = e;
        }
        dep.add((AuthorityFactory)factory);
        return dep;
    }

    @Override
    boolean sameAuthorityCodes(AuthorityFactory factory) {
        if (!this.isCodeMethodOverriden() && AuthorityFactoryAdapter.sameAuthorityCodes((AuthorityFactory)this.crsFactory, factory) && AuthorityFactoryAdapter.sameAuthorityCodes((AuthorityFactory)this.csFactory, factory) && AuthorityFactoryAdapter.sameAuthorityCodes((AuthorityFactory)this.datumFactory, factory) && AuthorityFactoryAdapter.sameAuthorityCodes((AuthorityFactory)this.operationFactory, factory)) {
            return true;
        }
        return super.sameAuthorityCodes(factory);
    }

    static boolean sameAuthorityCodes(AuthorityFactory backingStore, AuthorityFactory factory) {
        if (backingStore instanceof AbstractAuthorityFactory && ((AbstractAuthorityFactory)backingStore).sameAuthorityCodes(factory)) {
            return true;
        }
        return factory == backingStore || backingStore == null;
    }

    @Override
    public boolean isAvailable() {
        return AuthorityFactoryAdapter.isAvailable((AuthorityFactory)this.crsFactory) && AuthorityFactoryAdapter.isAvailable((AuthorityFactory)this.csFactory) && AuthorityFactoryAdapter.isAvailable((AuthorityFactory)this.datumFactory) && AuthorityFactoryAdapter.isAvailable((AuthorityFactory)this.operationFactory);
    }

    private static boolean isAvailable(AuthorityFactory factory) {
        return !(factory instanceof OptionalFactory) || ((OptionalFactory)factory).isAvailable();
    }

    Unit<?> replace(Unit<?> units) throws FactoryException {
        return units;
    }

    CoordinateSystemAxis replace(CoordinateSystemAxis axis) throws FactoryException {
        return axis;
    }

    CoordinateSystem replace(CoordinateSystem cs) throws FactoryException {
        return cs;
    }

    Datum replace(Datum datum) throws FactoryException {
        return datum;
    }

    CoordinateReferenceSystem replace(CoordinateReferenceSystem crs) throws FactoryException {
        return crs;
    }

    CoordinateOperation replace(CoordinateOperation operation) throws FactoryException {
        return operation;
    }

    private IdentifiedObject replaceObject(IdentifiedObject object) throws FactoryException {
        if (object instanceof CoordinateReferenceSystem) {
            return this.replace((CoordinateReferenceSystem)object);
        }
        if (object instanceof CoordinateSystem) {
            return this.replace((CoordinateSystem)object);
        }
        if (object instanceof CoordinateSystemAxis) {
            return this.replace((CoordinateSystemAxis)object);
        }
        if (object instanceof Datum) {
            return this.replace((Datum)object);
        }
        if (object instanceof CoordinateOperation) {
            return this.replace((CoordinateOperation)object);
        }
        return object;
    }

    private AbstractAuthorityFactory getGeotoolsFactory(String caller, String code) throws FactoryException {
        AuthorityFactory candidate = this.getAuthorityFactory(code);
        if (candidate instanceof AbstractAuthorityFactory) {
            return (AbstractAuthorityFactory)candidate;
        }
        if (caller == null) {
            return null;
        }
        throw new FactoryException(Errors.format((int)52, (Object)caller));
    }

    @Override
    public String getBackingStoreDescription() throws FactoryException {
        AbstractAuthorityFactory factory = this.getGeotoolsFactory(null, null);
        return factory != null ? factory.getBackingStoreDescription() : null;
    }

    @Override
    public Citation getVendor() {
        return this.getAuthorityFactory().getVendor();
    }

    @Override
    public Citation getAuthority() {
        return this.getAuthorityFactory().getAuthority();
    }

    public Set<String> getAuthorityCodes(Class<? extends IdentifiedObject> type) throws FactoryException {
        return this.getAuthorityFactory(null).getAuthorityCodes(type);
    }

    public InternationalString getDescriptionText(String code) throws FactoryException {
        return this.getAuthorityFactory(code).getDescriptionText(this.toBackingFactoryCode(code));
    }

    @Override
    public IdentifiedObject createObject(String code) throws FactoryException {
        return this.replaceObject(this.getAuthorityFactory(code).createObject(this.toBackingFactoryCode(code)));
    }

    @Override
    public Datum createDatum(String code) throws FactoryException {
        return this.replace(this.getDatumAuthorityFactory(code).createDatum(this.toBackingFactoryCode(code)));
    }

    @Override
    public EngineeringDatum createEngineeringDatum(String code) throws FactoryException {
        return (EngineeringDatum)this.replace((Datum)this.getDatumAuthorityFactory(code).createEngineeringDatum(this.toBackingFactoryCode(code)));
    }

    @Override
    public ImageDatum createImageDatum(String code) throws FactoryException {
        return (ImageDatum)this.replace((Datum)this.getDatumAuthorityFactory(code).createImageDatum(this.toBackingFactoryCode(code)));
    }

    @Override
    public VerticalDatum createVerticalDatum(String code) throws FactoryException {
        return (VerticalDatum)this.replace((Datum)this.getDatumAuthorityFactory(code).createVerticalDatum(this.toBackingFactoryCode(code)));
    }

    @Override
    public TemporalDatum createTemporalDatum(String code) throws FactoryException {
        return (TemporalDatum)this.replace((Datum)this.getDatumAuthorityFactory(code).createTemporalDatum(this.toBackingFactoryCode(code)));
    }

    @Override
    public GeodeticDatum createGeodeticDatum(String code) throws FactoryException {
        return (GeodeticDatum)this.replace((Datum)this.getDatumAuthorityFactory(code).createGeodeticDatum(this.toBackingFactoryCode(code)));
    }

    @Override
    public Ellipsoid createEllipsoid(String code) throws FactoryException {
        return this.getDatumAuthorityFactory(code).createEllipsoid(this.toBackingFactoryCode(code));
    }

    @Override
    public PrimeMeridian createPrimeMeridian(String code) throws FactoryException {
        return this.getDatumAuthorityFactory(code).createPrimeMeridian(this.toBackingFactoryCode(code));
    }

    @Override
    public Extent createExtent(String code) throws FactoryException {
        return this.getGeotoolsFactory("createExtent", code).createExtent(this.toBackingFactoryCode(code));
    }

    @Override
    public CoordinateSystem createCoordinateSystem(String code) throws FactoryException {
        return this.replace(this.getCSAuthorityFactory(code).createCoordinateSystem(this.toBackingFactoryCode(code)));
    }

    @Override
    public CartesianCS createCartesianCS(String code) throws FactoryException {
        return (CartesianCS)this.replace((CoordinateSystem)this.getCSAuthorityFactory(code).createCartesianCS(this.toBackingFactoryCode(code)));
    }

    @Override
    public PolarCS createPolarCS(String code) throws FactoryException {
        return (PolarCS)this.replace((CoordinateSystem)this.getCSAuthorityFactory(code).createPolarCS(this.toBackingFactoryCode(code)));
    }

    @Override
    public CylindricalCS createCylindricalCS(String code) throws FactoryException {
        return (CylindricalCS)this.replace((CoordinateSystem)this.getCSAuthorityFactory(code).createCylindricalCS(this.toBackingFactoryCode(code)));
    }

    @Override
    public SphericalCS createSphericalCS(String code) throws FactoryException {
        return (SphericalCS)this.replace((CoordinateSystem)this.getCSAuthorityFactory(code).createSphericalCS(this.toBackingFactoryCode(code)));
    }

    @Override
    public EllipsoidalCS createEllipsoidalCS(String code) throws FactoryException {
        return (EllipsoidalCS)this.replace((CoordinateSystem)this.getCSAuthorityFactory(code).createEllipsoidalCS(this.toBackingFactoryCode(code)));
    }

    @Override
    public VerticalCS createVerticalCS(String code) throws FactoryException {
        return (VerticalCS)this.replace((CoordinateSystem)this.getCSAuthorityFactory(code).createVerticalCS(this.toBackingFactoryCode(code)));
    }

    @Override
    public TimeCS createTimeCS(String code) throws FactoryException {
        return (TimeCS)this.replace((CoordinateSystem)this.getCSAuthorityFactory(code).createTimeCS(this.toBackingFactoryCode(code)));
    }

    @Override
    public CoordinateSystemAxis createCoordinateSystemAxis(String code) throws FactoryException {
        return this.replace(this.getCSAuthorityFactory(code).createCoordinateSystemAxis(this.toBackingFactoryCode(code)));
    }

    @Override
    public Unit<?> createUnit(String code) throws FactoryException {
        return this.replace(this.getCSAuthorityFactory(code).createUnit(this.toBackingFactoryCode(code)));
    }

    @Override
    public CoordinateReferenceSystem createCoordinateReferenceSystem(String code) throws FactoryException {
        return this.replace(this.getCRSAuthorityFactory(code).createCoordinateReferenceSystem(this.toBackingFactoryCode(code)));
    }

    @Override
    public CompoundCRS createCompoundCRS(String code) throws FactoryException {
        return (CompoundCRS)this.replace((CoordinateReferenceSystem)this.getCRSAuthorityFactory(code).createCompoundCRS(this.toBackingFactoryCode(code)));
    }

    @Override
    public DerivedCRS createDerivedCRS(String code) throws FactoryException {
        return (DerivedCRS)this.replace((CoordinateReferenceSystem)this.getCRSAuthorityFactory(code).createDerivedCRS(this.toBackingFactoryCode(code)));
    }

    @Override
    public EngineeringCRS createEngineeringCRS(String code) throws FactoryException {
        return (EngineeringCRS)this.replace((CoordinateReferenceSystem)this.getCRSAuthorityFactory(code).createEngineeringCRS(this.toBackingFactoryCode(code)));
    }

    @Override
    public GeographicCRS createGeographicCRS(String code) throws FactoryException {
        return (GeographicCRS)this.replace((CoordinateReferenceSystem)this.getCRSAuthorityFactory(code).createGeographicCRS(this.toBackingFactoryCode(code)));
    }

    @Override
    public GeocentricCRS createGeocentricCRS(String code) throws FactoryException {
        return (GeocentricCRS)this.replace((CoordinateReferenceSystem)this.getCRSAuthorityFactory(code).createGeocentricCRS(this.toBackingFactoryCode(code)));
    }

    @Override
    public ImageCRS createImageCRS(String code) throws FactoryException {
        return (ImageCRS)this.replace((CoordinateReferenceSystem)this.getCRSAuthorityFactory(code).createImageCRS(this.toBackingFactoryCode(code)));
    }

    @Override
    public ProjectedCRS createProjectedCRS(String code) throws FactoryException {
        return (ProjectedCRS)this.replace((CoordinateReferenceSystem)this.getCRSAuthorityFactory(code).createProjectedCRS(this.toBackingFactoryCode(code)));
    }

    @Override
    public TemporalCRS createTemporalCRS(String code) throws FactoryException {
        return (TemporalCRS)this.replace((CoordinateReferenceSystem)this.getCRSAuthorityFactory(code).createTemporalCRS(this.toBackingFactoryCode(code)));
    }

    @Override
    public VerticalCRS createVerticalCRS(String code) throws FactoryException {
        return (VerticalCRS)this.replace((CoordinateReferenceSystem)this.getCRSAuthorityFactory(code).createVerticalCRS(this.toBackingFactoryCode(code)));
    }

    @Override
    public ParameterDescriptor createParameterDescriptor(String code) throws FactoryException {
        return this.getGeotoolsFactory("createParameterDescriptor", code).createParameterDescriptor(this.toBackingFactoryCode(code));
    }

    @Override
    public OperationMethod createOperationMethod(String code) throws FactoryException {
        return this.getGeotoolsFactory("createOperationMethod", code).createOperationMethod(this.toBackingFactoryCode(code));
    }

    @Override
    public CoordinateOperation createCoordinateOperation(String code) throws FactoryException {
        return this.replace(this.getCoordinateOperationAuthorityFactory(code).createCoordinateOperation(this.toBackingFactoryCode(code)));
    }

    @Override
    public Set<CoordinateOperation> createFromCoordinateReferenceSystemCodes(String sourceCRS, String targetCRS) throws FactoryException {
        CoordinateOperationAuthorityFactory check;
        CoordinateOperationAuthorityFactory factory = this.getCoordinateOperationAuthorityFactory(sourceCRS);
        if (factory != (check = this.getCoordinateOperationAuthorityFactory(targetCRS))) {
            LogRecord record = Loggings.format((Level)Level.WARNING, (int)29, (Object)sourceCRS, (Object)targetCRS);
            record.setSourceMethodName("createFromCoordinateReferenceSystemCodes");
            record.setSourceClassName(AuthorityFactoryAdapter.class.getName());
            record.setLoggerName(LOGGER.getName());
            LOGGER.log(record);
            return Collections.emptySet();
        }
        return factory.createFromCoordinateReferenceSystemCodes(this.toBackingFactoryCode(sourceCRS), this.toBackingFactoryCode(targetCRS));
    }

    @Override
    public IdentifiedObjectFinder getIdentifiedObjectFinder(Class<? extends IdentifiedObject> type) throws FactoryException {
        return new Finder(type);
    }

    private FactoryException missingFactory(Class category, String code) {
        return new NoSuchAuthorityCodeException(Errors.format((int)49, (Object)category), Citations.getIdentifier((Citation)this.getAuthority()), this.trimAuthority(code));
    }

    private AuthorityFactory getAuthorityFactory() {
        try {
            return this.getAuthorityFactory(null);
        }
        catch (FactoryException cause) {
            throw new IllegalStateException(Errors.format((int)170), cause);
        }
    }

    <T extends AuthorityFactory> T getAuthorityFactory(Class<T> type, String code) throws FactoryException {
        CRSAuthorityFactory f;
        if (CRSAuthorityFactory.class.equals(type)) {
            f = this.getCRSAuthorityFactory(code);
        } else if (CSAuthorityFactory.class.equals(type)) {
            f = this.getCSAuthorityFactory(code);
        } else if (DatumAuthorityFactory.class.equals(type)) {
            f = this.getDatumAuthorityFactory(code);
        } else if (CoordinateOperationAuthorityFactory.class.equals(type)) {
            f = this.getCoordinateOperationAuthorityFactory(code);
        } else {
            throw new IllegalArgumentException(Errors.format((int)58, (Object)"type", type));
        }
        return (T)((AuthorityFactory)type.cast(f));
    }

    protected AuthorityFactory getAuthorityFactory(String code) throws FactoryException {
        if (this.crsFactory != null) {
            return this.crsFactory;
        }
        if (this.csFactory != null) {
            return this.csFactory;
        }
        if (this.datumFactory != null) {
            return this.datumFactory;
        }
        if (this.operationFactory != null) {
            return this.operationFactory;
        }
        throw this.missingFactory(AuthorityFactory.class, code);
    }

    protected DatumAuthorityFactory getDatumAuthorityFactory(String code) throws FactoryException {
        if (this.datumFactory == null) {
            throw this.missingFactory(DatumAuthorityFactory.class, code);
        }
        return this.datumFactory;
    }

    protected CSAuthorityFactory getCSAuthorityFactory(String code) throws FactoryException {
        if (this.csFactory == null) {
            throw this.missingFactory(CSAuthorityFactory.class, code);
        }
        return this.csFactory;
    }

    protected CRSAuthorityFactory getCRSAuthorityFactory(String code) throws FactoryException {
        if (this.crsFactory == null) {
            throw this.missingFactory(CRSAuthorityFactory.class, code);
        }
        return this.crsFactory;
    }

    protected CoordinateOperationAuthorityFactory getCoordinateOperationAuthorityFactory(String code) throws FactoryException {
        if (this.operationFactory == null) {
            throw this.missingFactory(CoordinateOperationAuthorityFactory.class, code);
        }
        return this.operationFactory;
    }

    final CoordinateOperationFactory getCoordinateOperationFactory() throws FactoryException {
        Factory factory;
        Map hints;
        Object candidate;
        if (this.operationFactory instanceof Factory && (candidate = (hints = (factory = (Factory)this.operationFactory).getImplementationHints()).get(Hints.COORDINATE_OPERATION_FACTORY)) instanceof CoordinateOperationFactory) {
            return (CoordinateOperationFactory)candidate;
        }
        return ReferencingFactoryFinder.getCoordinateOperationFactory(this.hints());
    }

    final ReferencingFactoryContainer getFactoryContainer(boolean crs) {
        Object factory = crs ? this.crsFactory : this.csFactory;
        if (factory instanceof DirectAuthorityFactory) {
            return ((DirectAuthorityFactory)((Object)factory)).factories;
        }
        if (this.factories == null) {
            this.factories = ReferencingFactoryContainer.instance(this.hints());
        }
        return this.factories;
    }

    protected String toBackingFactoryCode(String code) throws FactoryException {
        return code;
    }

    final boolean isCodeMethodOverriden() {
        Class[] arguments = new Class[]{String.class};
        Class<?> type = ((Object)((Object)this)).getClass();
        while (!AuthorityFactoryAdapter.class.equals(type)) {
            block4: {
                try {
                    type.getDeclaredMethod("toBackingFactoryCode", arguments);
                }
                catch (NoSuchMethodException e) {
                    break block4;
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                return true;
            }
            type = type.getSuperclass();
        }
        return false;
    }

    @Override
    public void dispose() throws FactoryException {
        super.dispose();
        this.disposeAbstractAuthorityFactory(this.datumFactory);
        this.disposeAbstractAuthorityFactory(this.csFactory);
        this.disposeAbstractAuthorityFactory(this.crsFactory);
        this.disposeAbstractAuthorityFactory(this.operationFactory);
    }

    private void disposeAbstractAuthorityFactory(Object factory) throws FactoryException {
        if (factory instanceof AbstractAuthorityFactory) {
            ((AbstractAuthorityFactory)((Object)factory)).dispose();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Finder
    extends IdentifiedObjectFinder.Adapter {
        protected Finder(Class<? extends IdentifiedObject> type) throws FactoryException {
            super(AuthorityFactoryAdapter.this.getGeotoolsFactory("getIdentifiedObjectFinder", null).getIdentifiedObjectFinder(type));
        }

        @Override
        protected IdentifiedObject deriveEquivalent(IdentifiedObject candidate, IdentifiedObject model) throws FactoryException {
            IdentifiedObject modified = AuthorityFactoryAdapter.this.replaceObject(candidate);
            if (modified != candidate && CRS.equalsIgnoreMetadata(modified, model)) {
                return modified;
            }
            return super.deriveEquivalent(candidate, model);
        }
    }
}

