package org.gcube.data.analysis.tabulardata.api;

public class OperationMonitor {

	public enum State {ONGOING, INITIALIZING, COMPLETED, FAILED};
	
	private float progress;
	
	private State state;
	
	private String statusDescription;
	
	private Throwable error;

	public OperationMonitor() {
		this.state = State.INITIALIZING;
		this.progress = 0;
	}

	public float getProgress() {
		return progress;
	}

	
	public void setProgress(float progress) {
		this.progress = progress;
	}

	public State getStatus() {
		return state;
	}

	public void setState(State state) {
		this.state = state;
		this.statusDescription=state.name();
	}

	public String getStatusDescription() {
		return statusDescription;
	}

	public void setStatusDescription(String statusDescription) {
		this.statusDescription = statusDescription;
	}

	public Throwable getError() {
		return error;
	}

	public void setError(Throwable error) {
		this.error = error;
	}
}
