/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.clientlibrary.proxy;

import java.util.List;
import javax.jws.soap.SOAPBinding;
import org.gcube.common.calls.jaxws.JAXWSUtils;
import org.gcube.common.clients.Call;
import org.gcube.common.clients.delegates.ProxyDelegate;
import org.gcube.common.clients.exceptions.FaultDSL;
import org.gcube.data.analysis.tabulardata.clientlibrary.proxy.RuleManagerProxy;
import org.gcube.data.analysis.tabulardata.commons.rules.RuleScope;
import org.gcube.data.analysis.tabulardata.commons.rules.types.RuleColumnType;
import org.gcube.data.analysis.tabulardata.commons.utils.AuthorizationToken;
import org.gcube.data.analysis.tabulardata.commons.webservice.RuleManager;
import org.gcube.data.analysis.tabulardata.commons.webservice.exception.InternalSecurityException;
import org.gcube.data.analysis.tabulardata.commons.webservice.exception.NoSuchRuleException;
import org.gcube.data.analysis.tabulardata.commons.webservice.exception.NoSuchTabularResourceException;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.AppliedRulesResponse;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.RuleDescription;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.tasks.TaskInfo;
import org.gcube.data.analysis.tabulardata.expression.Expression;
import org.gcube.data.analysis.tabulardata.model.datatype.DataType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRuleManagerProxy
implements RuleManagerProxy {
    ProxyDelegate<RuleManager> delegate;
    private static Logger logger = LoggerFactory.getLogger(DefaultRuleManagerProxy.class);

    public DefaultRuleManagerProxy(ProxyDelegate<RuleManager> config) {
        this.delegate = config;
    }

    @Override
    public long saveColumnRule(final String name, final String description, final Expression rule, final RuleColumnType columnType) {
        Call<RuleManager, Long> call = new Call<RuleManager, Long>(){

            public Long call(RuleManager endpoint) throws Exception {
                return endpoint.saveColumnRule(name, description, rule, columnType);
            }
        };
        try {
            return (Long)this.delegate.make((Call)call);
        }
        catch (InternalSecurityException e) {
            throw new SecurityException(e);
        }
        catch (Exception e) {
            logger.error("error saving rule", (Throwable)e);
            throw FaultDSL.again((Throwable)e).asServiceException();
        }
    }

    @Override
    public List<RuleDescription> getRules() {
        Call<RuleManager, List<RuleDescription>> call = new Call<RuleManager, List<RuleDescription>>(){

            public List<RuleDescription> call(RuleManager endpoint) throws Exception {
                return endpoint.getRules();
            }
        };
        try {
            return (List)this.delegate.make((Call)call);
        }
        catch (InternalSecurityException e) {
            throw new SecurityException(e);
        }
        catch (Exception e) {
            logger.error("error getting rules", (Throwable)e);
            throw FaultDSL.again((Throwable)e).asServiceException();
        }
    }

    @Override
    public List<RuleDescription> getRulesByScope(final RuleScope scope) {
        Call<RuleManager, List<RuleDescription>> call = new Call<RuleManager, List<RuleDescription>>(){

            public List<RuleDescription> call(RuleManager endpoint) throws Exception {
                return endpoint.getRulesByScope(scope);
            }
        };
        try {
            return (List)this.delegate.make((Call)call);
        }
        catch (InternalSecurityException e) {
            throw new SecurityException(e);
        }
        catch (Exception e) {
            logger.error("error getting rules", (Throwable)e);
            throw FaultDSL.again((Throwable)e).asServiceException();
        }
    }

    @Override
    public void remove(final Long id) throws NoSuchRuleException {
        Call<RuleManager, JAXWSUtils.Empty> call = new Call<RuleManager, JAXWSUtils.Empty>(){

            public JAXWSUtils.Empty call(RuleManager endpoint) throws Exception {
                endpoint.remove(id);
                return new JAXWSUtils.Empty();
            }
        };
        try {
            this.delegate.make((Call)call);
        }
        catch (NoSuchRuleException nsr) {
            throw nsr;
        }
        catch (InternalSecurityException e) {
            throw new SecurityException(e);
        }
        catch (Exception e) {
            logger.error("error removing rule", (Throwable)e);
            throw FaultDSL.again((Throwable)e).asServiceException();
        }
    }

    @Override
    public void updateColumnRule(final long id, final String name, final String description, final Expression rule, final RuleColumnType columnType) throws NoSuchRuleException {
        Call<RuleManager, JAXWSUtils.Empty> call = new Call<RuleManager, JAXWSUtils.Empty>(){

            public JAXWSUtils.Empty call(RuleManager endpoint) throws Exception {
                endpoint.updateColumnRule(Long.valueOf(id), name, description, rule, columnType);
                return new JAXWSUtils.Empty();
            }
        };
        try {
            this.delegate.make((Call)call);
        }
        catch (NoSuchRuleException nsr) {
            throw nsr;
        }
        catch (InternalSecurityException e) {
            throw new SecurityException(e);
        }
        catch (Exception e) {
            logger.error("error updating rules");
            throw FaultDSL.again((Throwable)e).asServiceException();
        }
    }

    @Override
    public List<RuleDescription> getApplicableBaseColumnRules(final Class<? extends DataType> dataTypeClass) {
        Call<RuleManager, List<RuleDescription>> call = new Call<RuleManager, List<RuleDescription>>(){

            public List<RuleDescription> call(RuleManager endpoint) throws Exception {
                return endpoint.getApplicableBaseColumnRules(dataTypeClass);
            }
        };
        try {
            return (List)this.delegate.make((Call)call);
        }
        catch (InternalSecurityException e) {
            throw new SecurityException(e);
        }
        catch (Exception e) {
            logger.error("error getting applicable rules");
            throw FaultDSL.again((Throwable)e).asServiceException();
        }
    }

    @Override
    public TaskInfo applyColumnRule(final Long tabularResourceId, final String columnId, final List<Long> ruleIds) throws NoSuchRuleException, NoSuchTabularResourceException {
        Call<RuleManager, TaskInfo> call = new Call<RuleManager, TaskInfo>(){

            public TaskInfo call(RuleManager endpoint) throws Exception {
                return endpoint.applyColumnRule(tabularResourceId, columnId, ruleIds);
            }
        };
        try {
            return (TaskInfo)this.delegate.make((Call)call);
        }
        catch (InternalSecurityException e) {
            throw new SecurityException(e);
        }
        catch (NoSuchRuleException nsr) {
            throw nsr;
        }
        catch (NoSuchTabularResourceException nstr) {
            throw nstr;
        }
        catch (Exception e) {
            logger.error("error applying rules");
            throw FaultDSL.again((Throwable)e).asServiceException();
        }
    }

    @Override
    public AppliedRulesResponse getAppliedRulesByTabularResourceId(final Long id) throws NoSuchTabularResourceException {
        Call<RuleManager, AppliedRulesResponse> call = new Call<RuleManager, AppliedRulesResponse>(){

            public AppliedRulesResponse call(RuleManager endpoint) throws Exception {
                return endpoint.getAppliedRulesByTabularResourceId(id);
            }
        };
        try {
            return (AppliedRulesResponse)this.delegate.make((Call)call);
        }
        catch (InternalSecurityException e) {
            throw new SecurityException(e);
        }
        catch (NoSuchTabularResourceException nstr) {
            throw nstr;
        }
        catch (Exception e) {
            logger.error("error applying rules");
            throw FaultDSL.again((Throwable)e).asServiceException();
        }
    }

    @SOAPBinding(parameterStyle=SOAPBinding.ParameterStyle.WRAPPED)
    public RuleDescription share(final Long entityId, final AuthorizationToken ... authTokens) throws NoSuchRuleException, InternalSecurityException {
        Call<RuleManager, RuleDescription> call = new Call<RuleManager, RuleDescription>(){

            public RuleDescription call(RuleManager endpoint) throws Exception {
                return (RuleDescription)endpoint.share((Object)entityId, authTokens);
            }
        };
        try {
            return (RuleDescription)this.delegate.make((Call)call);
        }
        catch (InternalSecurityException e) {
            throw new SecurityException(e);
        }
        catch (NoSuchRuleException nte) {
            throw nte;
        }
        catch (Exception e) {
            throw FaultDSL.again((Throwable)e).asServiceException();
        }
    }

    @SOAPBinding(parameterStyle=SOAPBinding.ParameterStyle.WRAPPED)
    public RuleDescription unshare(final Long entityId, final AuthorizationToken ... authTokens) throws NoSuchRuleException, InternalSecurityException {
        Call<RuleManager, RuleDescription> call = new Call<RuleManager, RuleDescription>(){

            public RuleDescription call(RuleManager endpoint) throws Exception {
                return (RuleDescription)endpoint.unshare((Object)entityId, authTokens);
            }
        };
        try {
            return (RuleDescription)this.delegate.make((Call)call);
        }
        catch (InternalSecurityException e) {
            throw new SecurityException(e);
        }
        catch (NoSuchRuleException nte) {
            throw nte;
        }
        catch (Exception e) {
            throw FaultDSL.again((Throwable)e).asServiceException();
        }
    }
}

