/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.clientlibrary.proxy;

import java.util.List;
import org.gcube.common.clients.Call;
import org.gcube.common.clients.delegates.ProxyDelegate;
import org.gcube.common.clients.exceptions.FaultDSL;
import org.gcube.data.analysis.tabulardata.clientlibrary.proxy.TemplateManagerProxy;
import org.gcube.data.analysis.tabulardata.commons.templates.model.Template;
import org.gcube.data.analysis.tabulardata.commons.utils.AuthorizationToken;
import org.gcube.data.analysis.tabulardata.commons.webservice.TemplateManager;
import org.gcube.data.analysis.tabulardata.commons.webservice.exception.NoSuchTabularResourceException;
import org.gcube.data.analysis.tabulardata.commons.webservice.exception.NoSuchTemplateException;
import org.gcube.data.analysis.tabulardata.commons.webservice.exception.TemplateNotCompatibleException;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.TemplateDescription;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.tasks.TaskInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTemplateManagerProxy
implements TemplateManagerProxy {
    ProxyDelegate<TemplateManager> delegate;
    private static Logger logger = LoggerFactory.getLogger(DefaultTemplateManagerProxy.class);

    public DefaultTemplateManagerProxy(ProxyDelegate<TemplateManager> config) {
        this.delegate = config;
    }

    public long saveTemplate(final String name, final String description, final String agency, final Template template) {
        Call<TemplateManager, Long> call = new Call<TemplateManager, Long>(){

            public Long call(TemplateManager endpoint) throws Exception {
                return endpoint.saveTemplate(name, description, agency, template);
            }
        };
        try {
            return (Long)this.delegate.make((Call)call);
        }
        catch (Exception e) {
            logger.error("error saving template");
            throw FaultDSL.again((Throwable)e).asServiceException();
        }
    }

    public TemplateDescription removeTemplate(final long id) throws NoSuchTemplateException {
        Call<TemplateManager, TemplateDescription> call = new Call<TemplateManager, TemplateDescription>(){

            public TemplateDescription call(TemplateManager endpoint) throws Exception {
                return endpoint.removeTemplate(id);
            }
        };
        try {
            return (TemplateDescription)this.delegate.make((Call)call);
        }
        catch (NoSuchTemplateException nste) {
            logger.error("error removing template with id " + id);
            throw nste;
        }
        catch (Exception e) {
            logger.error("error removing template");
            throw FaultDSL.again((Throwable)e).asServiceException();
        }
    }

    public TemplateDescription updateTemplate(final long id, final Template template) throws NoSuchTemplateException {
        Call<TemplateManager, TemplateDescription> call = new Call<TemplateManager, TemplateDescription>(){

            public TemplateDescription call(TemplateManager endpoint) throws Exception {
                return endpoint.updateTemplate(id, template);
            }
        };
        try {
            return (TemplateDescription)this.delegate.make((Call)call);
        }
        catch (NoSuchTemplateException nste) {
            logger.error("error removing template with id " + id);
            throw nste;
        }
        catch (Exception e) {
            logger.error("error removing template");
            throw FaultDSL.again((Throwable)e).asServiceException();
        }
    }

    public List<TemplateDescription> getTemplates() {
        Call<TemplateManager, List<TemplateDescription>> call = new Call<TemplateManager, List<TemplateDescription>>(){

            public List<TemplateDescription> call(TemplateManager endpoint) throws Exception {
                return endpoint.getTemplates();
            }
        };
        try {
            return (List)this.delegate.make((Call)call);
        }
        catch (Exception e) {
            logger.error("error getting templates");
            throw FaultDSL.again((Throwable)e).asServiceException();
        }
    }

    public TemplateDescription getTemplate(final long id) throws NoSuchTemplateException {
        Call<TemplateManager, TemplateDescription> call = new Call<TemplateManager, TemplateDescription>(){

            public TemplateDescription call(TemplateManager endpoint) throws Exception {
                return endpoint.getTemplate(id);
            }
        };
        try {
            return (TemplateDescription)this.delegate.make((Call)call);
        }
        catch (NoSuchTemplateException nste) {
            logger.error("error getting template with id " + id);
            throw nste;
        }
        catch (Exception e) {
            logger.error("error getting templates");
            throw FaultDSL.again((Throwable)e).asServiceException();
        }
    }

    public TemplateDescription share(final Long entityId, final AuthorizationToken ... authTokens) throws NoSuchTemplateException {
        Call<TemplateManager, TemplateDescription> call = new Call<TemplateManager, TemplateDescription>(){

            public TemplateDescription call(TemplateManager endpoint) throws Exception {
                return (TemplateDescription)endpoint.share((Object)entityId, authTokens);
            }
        };
        try {
            return (TemplateDescription)this.delegate.make((Call)call);
        }
        catch (SecurityException se) {
            throw se;
        }
        catch (NoSuchTemplateException nte) {
            throw nte;
        }
        catch (Exception e) {
            throw FaultDSL.again((Throwable)e).asServiceException();
        }
    }

    public TemplateDescription unshare(final Long entityId, final AuthorizationToken ... authTokens) throws NoSuchTemplateException {
        Call<TemplateManager, TemplateDescription> call = new Call<TemplateManager, TemplateDescription>(){

            public TemplateDescription call(TemplateManager endpoint) throws Exception {
                return (TemplateDescription)endpoint.unshare((Object)entityId, authTokens);
            }
        };
        try {
            return (TemplateDescription)this.delegate.make((Call)call);
        }
        catch (SecurityException se) {
            throw se;
        }
        catch (NoSuchTemplateException nte) {
            throw nte;
        }
        catch (Exception e) {
            throw FaultDSL.again((Throwable)e).asServiceException();
        }
    }

    public TaskInfo apply(final long templateId, final long tabularResourceId) throws NoSuchTemplateException, NoSuchTabularResourceException, TemplateNotCompatibleException {
        Call<TemplateManager, TaskInfo> call = new Call<TemplateManager, TaskInfo>(){

            public TaskInfo call(TemplateManager endpoint) throws Exception {
                return endpoint.apply(templateId, tabularResourceId);
            }
        };
        try {
            return (TaskInfo)this.delegate.make((Call)call);
        }
        catch (TemplateNotCompatibleException tmc) {
            logger.error("error applying template, template with id " + templateId + " not applicable to tabular resource with id " + tabularResourceId);
            throw tmc;
        }
        catch (NoSuchTemplateException nst) {
            logger.error("error applying template, template with id " + templateId + " not found");
            throw nst;
        }
        catch (NoSuchTabularResourceException nstr) {
            logger.error("error applying template, tabular resource with id " + tabularResourceId + " not found");
            throw nstr;
        }
        catch (Exception e) {
            logger.error("error applying template");
            throw FaultDSL.again((Throwable)e).asServiceException();
        }
    }
}

