/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.clientlibrary.proxy;

import java.util.List;
import org.gcube.common.clients.Call;
import org.gcube.common.clients.delegates.ProxyDelegate;
import org.gcube.common.clients.exceptions.FaultDSL;
import org.gcube.data.analysis.tabulardata.clientlibrary.proxy.TaskManagerProxy;
import org.gcube.data.analysis.tabulardata.commons.webservice.TaskManager;
import org.gcube.data.analysis.tabulardata.commons.webservice.exception.NoSuchTabularResourceException;
import org.gcube.data.analysis.tabulardata.commons.webservice.exception.NoSuchTaskException;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.TaskStatus;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.tasks.TaskInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTaskManagerProxy
implements TaskManagerProxy {
    ProxyDelegate<TaskManager> delegate;
    private static Logger logger = LoggerFactory.getLogger(DefaultTaskManagerProxy.class);

    public DefaultTaskManagerProxy(ProxyDelegate<TaskManager> config) {
        this.delegate = config;
    }

    @Override
    public TaskInfo remove(final String identifier) throws NoSuchTaskException {
        Call<TaskManager, TaskInfo> call = new Call<TaskManager, TaskInfo>(){

            public TaskInfo call(TaskManager endpoint) throws Exception {
                return endpoint.remove(identifier);
            }
        };
        try {
            return (TaskInfo)this.delegate.make((Call)call);
        }
        catch (NoSuchTaskException e) {
            logger.error("no task found with id {}", (Object)identifier);
            throw e;
        }
        catch (Exception e) {
            throw FaultDSL.again((Throwable)e).asServiceException();
        }
    }

    @Override
    public List<TaskInfo> get(final String ... identifiers) {
        Call<TaskManager, List<TaskInfo>> call = new Call<TaskManager, List<TaskInfo>>(){

            public List<TaskInfo> call(TaskManager endpoint) throws Exception {
                return endpoint.get(identifiers);
            }
        };
        try {
            return (List)this.delegate.make((Call)call);
        }
        catch (Exception e) {
            throw FaultDSL.again((Throwable)e).asServiceException();
        }
    }

    @Override
    public List<TaskInfo> getTasksByTabularResource(final long tabularResourceId) throws NoSuchTabularResourceException {
        Call<TaskManager, List<TaskInfo>> call = new Call<TaskManager, List<TaskInfo>>(){

            public List<TaskInfo> call(TaskManager endpoint) throws Exception {
                return endpoint.getTasksByTabularResource(Long.valueOf(tabularResourceId));
            }
        };
        try {
            return (List)this.delegate.make((Call)call);
        }
        catch (NoSuchTabularResourceException e) {
            throw e;
        }
        catch (Exception e) {
            throw FaultDSL.again((Throwable)e).asServiceException();
        }
    }

    @Override
    public TaskInfo abort(final String identifier) throws NoSuchTaskException {
        Call<TaskManager, TaskInfo> call = new Call<TaskManager, TaskInfo>(){

            public TaskInfo call(TaskManager endpoint) throws Exception {
                return endpoint.abort(identifier);
            }
        };
        try {
            return (TaskInfo)this.delegate.make((Call)call);
        }
        catch (NoSuchTaskException e) {
            logger.error("no task found with id {}", (Object)identifier);
            throw e;
        }
        catch (Exception e) {
            throw FaultDSL.again((Throwable)e).asServiceException();
        }
    }

    @Override
    public List<TaskInfo> getTasksByTabularResource(final long tabularResourceId, final TaskStatus status) throws NoSuchTabularResourceException {
        Call<TaskManager, List<TaskInfo>> call = new Call<TaskManager, List<TaskInfo>>(){

            public List<TaskInfo> call(TaskManager endpoint) throws Exception {
                return endpoint.getTasksByStatusAndTabularResource(Long.valueOf(tabularResourceId), status);
            }
        };
        try {
            return (List)this.delegate.make((Call)call);
        }
        catch (NoSuchTabularResourceException e) {
            throw e;
        }
        catch (Exception e) {
            throw FaultDSL.again((Throwable)e).asServiceException();
        }
    }

    @Override
    public TaskInfo resubmit(final String identifier) throws NoSuchTaskException {
        Call<TaskManager, TaskInfo> call = new Call<TaskManager, TaskInfo>(){

            public TaskInfo call(TaskManager endpoint) throws Exception {
                return endpoint.resubmit(identifier);
            }
        };
        try {
            return (TaskInfo)this.delegate.make((Call)call);
        }
        catch (NoSuchTaskException e) {
            logger.error("no task found with id {}", (Object)identifier);
            throw e;
        }
        catch (Exception e) {
            throw FaultDSL.again((Throwable)e).asServiceException();
        }
    }
}

