/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.clientlibrary.proxy;

import java.util.List;
import org.gcube.common.calls.jaxws.JAXWSUtils;
import org.gcube.common.clients.Call;
import org.gcube.common.clients.delegates.ProxyDelegate;
import org.gcube.common.clients.exceptions.FaultDSL;
import org.gcube.data.analysis.tabulardata.clientlibrary.proxy.TabularResourceManagerProxy;
import org.gcube.data.td.commons.webservice.TabularResourceManager;
import org.gcube.data.td.commons.webservice.exception.NoSuchTableException;
import org.gcube.data.td.commons.webservice.exception.NoSuchTabularResourceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTabularResourceManagerProxy
implements TabularResourceManagerProxy {
    private static Logger logger = LoggerFactory.getLogger(DefaultTabularResourceManagerProxy.class);
    private final ProxyDelegate<TabularResourceManager> delegate;

    public DefaultTabularResourceManagerProxy(ProxyDelegate<TabularResourceManager> config) {
        this.delegate = config;
    }

    public Long createTabularResource() throws Exception {
        Call<TabularResourceManager, Long> call = new Call<TabularResourceManager, Long>(){

            public Long call(TabularResourceManager endpoint) throws Exception {
                return endpoint.createTabularResource();
            }
        };
        return (Long)this.delegate.make((Call)call);
    }

    public void remove(final Long tabularResourceId) throws NoSuchTabularResourceException {
        Call<TabularResourceManager, JAXWSUtils.Empty> call = new Call<TabularResourceManager, JAXWSUtils.Empty>(){

            public JAXWSUtils.Empty call(TabularResourceManager endpoint) throws Exception {
                endpoint.remove(tabularResourceId);
                return new JAXWSUtils.Empty();
            }
        };
        try {
            this.delegate.make((Call)call);
        }
        catch (NoSuchTabularResourceException e) {
            logger.error("no tabular resource found with id {}", (Object)tabularResourceId);
            throw e;
        }
        catch (Exception e) {
            throw FaultDSL.again((Throwable)e).asServiceException();
        }
    }

    public Long cloneTabularResource(final Long tabularResourceId, final Long lastTableId) throws NoSuchTabularResourceException, NoSuchTableException {
        Call<TabularResourceManager, Long> call = new Call<TabularResourceManager, Long>(){

            public Long call(TabularResourceManager endpoint) throws Exception {
                return endpoint.cloneTabularResource(tabularResourceId, lastTableId);
            }
        };
        try {
            return (Long)this.delegate.make((Call)call);
        }
        catch (NoSuchTabularResourceException e) {
            logger.error("no tabular resource found with id {}", (Object)tabularResourceId);
            throw e;
        }
        catch (NoSuchTableException e) {
            logger.error("table with id {} not found, erorr on history", (Object)lastTableId);
            throw e;
        }
        catch (Exception e) {
            throw FaultDSL.again((Throwable)e).asServiceException();
        }
    }

    public List<Long> getAllTabularResourceIdentifiers() throws Exception {
        Call<TabularResourceManager, List<Long>> call = new Call<TabularResourceManager, List<Long>>(){

            public List<Long> call(TabularResourceManager endpoint) throws Exception {
                return endpoint.getAllTabularResourceIdentifiers();
            }
        };
        try {
            return (List)this.delegate.make((Call)call);
        }
        catch (Exception e) {
            throw FaultDSL.again((Throwable)e).asServiceException();
        }
    }
}

