package org.gcube.data.analysis.tabulardata.clientlibrary.proxy;

import java.util.List;
import java.util.UUID;

import org.gcube.data.analysis.tabulardata.operation.worker.EligibleOperation;
import org.gcube.data.analysis.tabulardata.operation.worker.OperationInvocation;
import org.gcube.data.td.commons.webservice.exception.InvalidInvocationException;
import org.gcube.data.td.commons.webservice.exception.NoSuchColumnException;
import org.gcube.data.td.commons.webservice.exception.NoSuchTabularResourceException;
import org.gcube.data.td.commons.webservice.exception.OperationNotFoundException;
import org.gcube.data.td.commons.webservice.types.TaskInfo;

public interface OperationManagerProxy {

	List<EligibleOperation> getCapabilities(long tabularResourceId,
			UUID columnId) throws NoSuchTabularResourceException,
			NoSuchColumnException;
	
	List<EligibleOperation> getCapabilities(long tabularResourceId) throws NoSuchTabularResourceException;
	
	List<EligibleOperation> getCapabilities();
	
	public TaskInfo execute(OperationInvocation invocation, long tableId) throws NoSuchTabularResourceException, InvalidInvocationException, OperationNotFoundException;
}
