/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.clientlibrary.proxy;

import org.gcube.common.clients.Call;
import org.gcube.common.clients.delegates.ProxyDelegate;
import org.gcube.common.clients.exceptions.FaultDSL;
import org.gcube.data.analysis.tabulardata.clientlibrary.proxy.TaskManagerProxy;
import org.gcube.data.td.commons.webservice.TaskManager;
import org.gcube.data.td.commons.webservice.exception.NoSuchTaskException;
import org.gcube.data.td.commons.webservice.types.TaskInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTaskManagerProxy
implements TaskManagerProxy {
    ProxyDelegate<TaskManager> delegate;
    private static Logger logger = LoggerFactory.getLogger(DefaultTaskManagerProxy.class);

    public DefaultTaskManagerProxy(ProxyDelegate<TaskManager> config) {
        this.delegate = config;
    }

    public TaskInfo remove(final String identifier) throws NoSuchTaskException {
        Call<TaskManager, TaskInfo> call = new Call<TaskManager, TaskInfo>(){

            public TaskInfo call(TaskManager endpoint) throws Exception {
                return endpoint.remove(identifier);
            }
        };
        try {
            return (TaskInfo)this.delegate.make((Call)call);
        }
        catch (NoSuchTaskException e) {
            logger.error("no task found with id {}", (Object)identifier);
            throw e;
        }
        catch (Exception e) {
            throw FaultDSL.again((Throwable)e).asServiceException();
        }
    }

    public TaskInfo get(final String identifier) throws NoSuchTaskException {
        Call<TaskManager, TaskInfo> call = new Call<TaskManager, TaskInfo>(){

            public TaskInfo call(TaskManager endpoint) throws Exception {
                return endpoint.get(identifier);
            }
        };
        try {
            return (TaskInfo)this.delegate.make((Call)call);
        }
        catch (NoSuchTaskException e) {
            logger.error("no task found with id {}", (Object)identifier);
            throw e;
        }
        catch (Exception e) {
            throw FaultDSL.again((Throwable)e).asServiceException();
        }
    }

    public TaskInfo abort(final String identifier) throws NoSuchTaskException {
        Call<TaskManager, TaskInfo> call = new Call<TaskManager, TaskInfo>(){

            public TaskInfo call(TaskManager endpoint) throws Exception {
                return endpoint.abort(identifier);
            }
        };
        try {
            return (TaskInfo)this.delegate.make((Call)call);
        }
        catch (NoSuchTaskException e) {
            logger.error("no task found with id {}", (Object)identifier);
            throw e;
        }
        catch (Exception e) {
            throw FaultDSL.again((Throwable)e).asServiceException();
        }
    }
}

