/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.query.sql;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import org.apache.commons.dbutils.DbUtils;
import org.apache.commons.dbutils.ResultSetHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLResultSetIterator
implements Iterator<Object[]> {
    Logger log = LoggerFactory.getLogger(SQLResultSetIterator.class);
    ResultSet rs;
    boolean empty = true;

    public SQLResultSetIterator(ResultSet rs) {
        this.rs = rs;
        try {
            if (rs.isBeforeFirst()) {
                this.empty = false;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean hasNext() {
        try {
            if (this.empty || this.rs.isClosed()) {
                return false;
            }
            return !this.rs.isLast();
        }
        catch (SQLException e) {
            throw new RuntimeException("Unable to read query result from DB. Check server logs.");
        }
    }

    @Override
    public Object[] next() {
        ObjectHandler rsh = new ObjectHandler();
        try {
            Object[] result = (Object[])rsh.handle(this.rs);
            if (this.rs.isLast()) {
                DbUtils.closeQuietly((Statement)this.rs.getStatement());
                DbUtils.closeQuietly((ResultSet)this.rs);
            }
            return result;
        }
        catch (SQLException e) {
            String msg = "Unable to read from ResultSet.";
            this.log.error(msg, (Throwable)e);
            throw new RuntimeException(msg, e);
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Remove operations is unsupported.");
    }

    class ObjectHandler
    implements ResultSetHandler<Object[]> {
        ObjectHandler() {
        }

        public Object[] handle(ResultSet rs) throws SQLException {
            if (!rs.next()) {
                return null;
            }
            ResultSetMetaData meta = rs.getMetaData();
            int cols = meta.getColumnCount();
            Object[] result = new Object[cols];
            for (int i = 0; i < cols; ++i) {
                result[i] = rs.getObject(i + 1);
            }
            return result;
        }
    }
}

