/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.query.json;

import java.util.Iterator;
import org.gcube.data.analysis.tabulardata.query.TabularQuery;
import org.gcube.data.analysis.tabulardata.query.json.TabularJSONQuery;
import org.gcube.data.analysis.tabulardata.query.parameters.QueryFilter;
import org.gcube.data.analysis.tabulardata.query.parameters.QueryOrder;
import org.gcube.data.analysis.tabulardata.query.parameters.QueryPage;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TabularJSONQueryImpl
implements TabularJSONQuery {
    private Logger log = LoggerFactory.getLogger(TabularJSONQueryImpl.class);
    private TabularQuery tabularQuery;

    public TabularJSONQueryImpl(TabularQuery tabularQuery) {
        this.tabularQuery = tabularQuery;
    }

    @Override
    public TabularJSONQuery setFilter(QueryFilter filter) {
        this.tabularQuery.setFilter(filter);
        return this;
    }

    @Override
    public TabularJSONQuery setOrdering(QueryOrder ordering) {
        this.tabularQuery.setOrdering(ordering);
        return this;
    }

    @Override
    public int getTotalTuples() {
        return this.tabularQuery.getTotalTuples();
    }

    @Override
    public String getPage(QueryPage page) {
        Iterator queryResult = (Iterator)this.tabularQuery.getPage(page);
        return this.generateJSONFromData(queryResult);
    }

    @Override
    public String getAll() {
        Iterator queryResult = (Iterator)this.tabularQuery.getAll();
        return this.generateJSONFromData(queryResult);
    }

    private String generateJSONFromData(Iterator<Object[]> dataIterator) {
        JSONObject json = new JSONObject();
        JSONArray jsonRows = new JSONArray();
        while (dataIterator.hasNext()) {
            Object[] row = dataIterator.next();
            jsonRows.put((Object)row);
        }
        try {
            json.put("rows", (Object)jsonRows);
        }
        catch (JSONException e) {
            this.log.error("Unable to produce JSON document.", (Throwable)e);
            throw new RuntimeException("Error occured with serialization of table content. Check server log.");
        }
        return json.toString();
    }
}

