/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.query;

import com.google.common.collect.Lists;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.dbutils.DbUtils;
import org.apache.commons.dbutils.QueryRunner;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.cube.data.connection.unprivileged.Unprivileged;
import org.gcube.data.analysis.tabulardata.cube.exceptions.NoSuchTableException;
import org.gcube.data.analysis.tabulardata.cube.exceptions.TableCreationException;
import org.gcube.data.analysis.tabulardata.cube.tablemanagers.TableCreator;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.ColumnType;
import org.gcube.data.analysis.tabulardata.model.metadata.levels.Level;
import org.gcube.data.analysis.tabulardata.model.metadata.levels.Levels;
import org.gcube.data.analysis.tabulardata.model.relationship.TableRelationship;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.model.table.TableType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class TabularQueryUtils {
    private DatabaseConnectionProvider connectionProvider;
    private CubeManager cm;
    private Logger log = LoggerFactory.getLogger(TabularQueryUtils.class);

    @Inject
    public TabularQueryUtils(@Unprivileged DatabaseConnectionProvider connectionProvider, CubeManager cm) {
        this.connectionProvider = connectionProvider;
        this.cm = cm;
    }

    public Table generateDatasetView(long tableId) {
        Table dataset = this.getTable(tableId);
        this.checkIfTableIsDataset(dataset);
        TableCreator ttc = this.cm.createTable(TableType.VIEWTABLE);
        try {
            ttc.like(dataset, false);
            List crCols = dataset.getColumns(ColumnType.CODELISTREF);
            for (Column column : crCols) {
                Table refTable = this.cm.getTable(column.getRelationship().getTargetTableRef().getTableId());
                List levels = (List)((Object)refTable.getMetadataObject(Levels.class));
                int i = 0;
                for (Iterator viewColumnName : ((Level)levels.get(0)).getViewColumnNames()) {
                    Column refColumn = refTable.getColumnByName((String)((Object)viewColumnName));
                    refColumn.setName(String.valueOf(column.getName()) + "_view" + i);
                    refColumn.setLabel(String.valueOf(column.getName()) + "_view" + i);
                    ++i;
                    ttc.addColumn(refColumn);
                }
            }
            Table viewTable = ttc.create();
            this.log.debug("Created view: " + viewTable);
            ArrayList refTables = Lists.newArrayList();
            for (TableRelationship rel : dataset.getRelationships()) {
                refTables.add(this.cm.getTable(rel.getTargetTableRef().getTableId()));
            }
            StringBuilder sqlSelect = new StringBuilder();
            sqlSelect.append("SELECT ");
            for (Column column : dataset.getColumns()) {
                if (column.getColumnType() == ColumnType.ID) continue;
                sqlSelect.append("d." + column.getName() + " ,");
            }
            int i = 0;
            for (Table table : refTables) {
                List levels = (List)((Object)table.getMetadataObject(Levels.class));
                Level level = (Level)levels.get(0);
                for (String levelColumnName : level.getViewColumnNames()) {
                    sqlSelect.append("c" + i + "." + levelColumnName + " ,");
                }
                ++i;
            }
            sqlSelect.deleteCharAt(sqlSelect.length() - 1);
            sqlSelect.append("FROM " + dataset.getName() + " AS d ");
            i = 0;
            for (TableRelationship rel : dataset.getRelationships()) {
                Table refTable = this.cm.getTable(rel.getTargetTableRef().getTableId());
                String refTableAlias = "c" + i;
                sqlSelect.append(" LEFT JOIN " + refTable.getName() + " AS " + refTableAlias + " ON d." + rel.getSourceTableFKRef().getColumnName() + " = " + refTableAlias + ".id");
                ++i;
            }
            StringBuilder orderedColumnNames = new StringBuilder();
            for (Column column : viewTable.getColumns()) {
                orderedColumnNames.append(String.valueOf(column.getName()) + " ,");
            }
            orderedColumnNames.deleteCharAt(orderedColumnNames.length() - 1);
            String sqlInsert = String.format("INSERT INTO %s (%s) ", viewTable.getName(), orderedColumnNames);
            String sql = String.valueOf(sqlInsert) + sqlSelect + ";";
            this.log.debug("Executing view filling SQL statement: " + sql);
            this.executeSQLCommand(sql);
            return viewTable;
        }
        catch (TableCreationException e) {
            this.log.error("Unable to create table", (Throwable)e);
            throw new RuntimeException("An error occurred during table creation. Check server logs.");
        }
        catch (NoSuchTableException e) {
            this.log.error("Unable to find referenced table.", (Throwable)e);
            throw new RuntimeException("An error occurred during table creation. Check server logs.");
        }
        catch (Exception e) {
            this.log.error("Generic exception detected.", (Throwable)e);
            throw new RuntimeException("An error occurred during table creation. Check server logs.");
        }
    }

    private Connection getConnection() throws SQLException {
        return this.connectionProvider.getConnection();
    }

    public ResultSet executeSQLQuery(String sql) {
        ResultSet rs;
        QueryRunner run = new QueryRunner();
        this.log.debug("Executing SQL Query: " + sql);
        Connection connection = null;
        Statement statement = null;
        try {
            try {
                connection = this.getConnection();
                statement = connection.createStatement();
                rs = statement.executeQuery(sql);
            }
            catch (SQLException e) {
                this.log.error("Unable to execute SQL query.", (Throwable)e);
                throw new RuntimeException("Unable to query the DB.");
            }
        }
        finally {
            DbUtils.closeQuietly((Connection)connection);
        }
        return rs;
    }

    public void executeSQLCommand(String sql) {
        this.log.debug("Exceuting SQL command: " + sql);
        Connection connection = null;
        Statement statement = null;
        try {
            try {
                connection = this.getConnection();
                statement = connection.createStatement();
                statement.execute(sql);
            }
            catch (SQLException e) {
                this.log.error("Unable to execute SQL query.", (Throwable)e);
                throw new RuntimeException("Unable to query the DB.");
            }
        }
        catch (Throwable throwable) {
            DbUtils.closeQuietly((Connection)connection);
            DbUtils.closeQuietly(statement);
            throw throwable;
        }
        DbUtils.closeQuietly((Connection)connection);
        DbUtils.closeQuietly((Statement)statement);
    }

    private void checkIfTableIsDataset(Table dataset) {
        if (dataset.getTableType() != TableType.DATASET) {
            throw new RuntimeException("The table with the given id is not a dataset.");
        }
    }

    private Table getTable(long tableId) {
        try {
            return this.cm.getTable(tableId);
        }
        catch (NoSuchTableException e) {
            this.log.error("Error occurred while querying table", (Throwable)e);
            throw new RuntimeException(String.format("Unable to retrieve metadata for the given table id '%s' . Check server logs.", tableId));
        }
    }
}

