/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.query;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.dbutils.DbUtils;
import org.gcube.data.analysis.tabulardata.expression.evaluator.sqlfilter.SQLFilterExpressionEvaluatorFactory;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.query.TabularQuery;
import org.gcube.data.analysis.tabulardata.query.TabularQueryUtils;
import org.gcube.data.analysis.tabulardata.query.params.Filter;
import org.gcube.data.analysis.tabulardata.query.params.Ordering;
import org.gcube.data.analysis.tabulardata.query.params.Page;
import org.gcube.data.analysis.tabulardata.query.sql.SQLResultSetIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TabularQueryImpl
implements TabularQuery {
    private Logger log = LoggerFactory.getLogger(TabularQueryImpl.class);
    private TabularQueryUtils queryUtils;
    private Table table;
    private Filter filter = null;
    private Ordering ordering = null;
    private Page page;
    private QueryBuilder queryBuilder = new QueryBuilder();

    public TabularQueryImpl(TabularQueryUtils queryUtils, Table table) {
        this.queryUtils = queryUtils;
        this.table = table;
    }

    @Override
    public TabularQuery setFilter(Filter filter) {
        this.filter = filter;
        return this;
    }

    @Override
    public TabularQuery setOrdering(Ordering ordering) {
        this.ordering = ordering;
        return this;
    }

    @Override
    public int getTotalTuples() {
        String sql = this.queryBuilder.buildCountTuplesQuery();
        ResultSet rs = this.queryUtils.executeSQLQuery(sql);
        int totalTuples = this.parseGetTotalTuplesQueryResult(rs);
        return totalTuples;
    }

    @Override
    public Iterator<Object[]> getPage(Page page) {
        this.page = page;
        return this.executeQuery();
    }

    @Override
    public Iterator<Object[]> getAll() {
        this.page = null;
        return this.executeQuery();
    }

    private Collection<Column> getColumnsToShow() {
        return this.table.getColumns();
    }

    private Iterator<Object[]> executeQuery() {
        this.checkIfOrderingColumnExists();
        String query = this.queryBuilder.buildQuery();
        return new SQLResultSetIterator(this.queryUtils.executeSQLQuery(query));
    }

    private void checkIfOrderingColumnExists() {
        if (this.ordering == null) {
            return;
        }
        try {
            this.table.getColumnByName(this.ordering.getOrderingColumnName());
        }
        catch (Exception e) {
            this.log.error(String.format("Provided ordering column name '%s' is not valid within table %s.", this.ordering.getOrderingColumnName(), this.table));
            throw new IllegalArgumentException("Given ordering column with name " + this.ordering.getOrderingColumnName() + " does not exists within the table with id " + this.table.getId());
        }
    }

    private int parseGetTotalTuplesQueryResult(ResultSet rs) {
        try {
            rs.next();
            int result = rs.getInt(1);
            DbUtils.closeQuietly((ResultSet)rs);
            return result;
        }
        catch (SQLException e) {
            this.log.error("An error occurred while querying the database.", (Throwable)e);
            throw new RuntimeException("An error occurred while querying the database. Check server logs");
        }
    }

    private class QueryBuilder {
        private QueryBuilder() {
        }

        private String buildQuery() {
            StringBuilder queryBuilder = new StringBuilder();
            queryBuilder.append(this.getQuerySelectPart());
            queryBuilder.append(this.getQueryFilterPart());
            queryBuilder.append(this.getOrderQueryPart());
            queryBuilder.append(this.getLimitQueryPart());
            queryBuilder.append(";");
            return queryBuilder.toString();
        }

        private String getQuerySelectPart() {
            String columns = this.buildColumnCommaSeparatedList(TabularQueryImpl.this.getColumnsToShow());
            return String.format("SELECT %s FROM %s ", columns, TabularQueryImpl.this.table.getName());
        }

        private String getQueryFilterPart() {
            if (TabularQueryImpl.this.filter == null) {
                return "";
            }
            SQLFilterExpressionEvaluatorFactory evaluatorFactory = SQLFilterExpressionEvaluatorFactory.getInstance();
            String whereCondition = (String)evaluatorFactory.getEvaluator(TabularQueryImpl.this.filter.getFilterExpression()).evaluate();
            return String.format(" WHERE %s ", whereCondition);
        }

        private String getOrderQueryPart() {
            if (TabularQueryImpl.this.ordering == null) {
                return "";
            }
            return String.format(" ORDER BY %s %s ", TabularQueryImpl.this.ordering.getOrderingColumnName(), TabularQueryImpl.this.ordering.getOrderingDirection().getSQLKeyword());
        }

        private String getLimitQueryPart() {
            if (TabularQueryImpl.this.page == null) {
                return "";
            }
            return String.format(" LIMIT %s OFFSET %s ", TabularQueryImpl.this.page.getPageSize(), TabularQueryImpl.this.page.getOffset());
        }

        private String buildColumnCommaSeparatedList(Collection<Column> columns) {
            String columnNames = "";
            int i = 1;
            for (Column c : columns) {
                columnNames = String.valueOf(columnNames) + c.getName();
                if (i++ >= columns.size()) continue;
                columnNames = String.valueOf(columnNames) + ",";
            }
            return columnNames;
        }

        private String buildCountTuplesQuery() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.buildSelectCountFirstPart());
            stringBuilder.append(this.getQueryFilterPart());
            stringBuilder.append(";");
            return stringBuilder.toString();
        }

        private String buildSelectCountFirstPart() {
            return String.format("SELECT COUNT(*) FROM %s ", TabularQueryImpl.this.table.getName());
        }
    }
}

