package org.gcube.data.analysis.tabulardata.query;

import javax.inject.Inject;
import javax.inject.Singleton;

import org.gcube.data.analysis.tabulardata.model.table.Table;

@Singleton
public class TabularQueryFactory {
	
	private TabularQueryUtils tabularQueryUtils;

	@Inject
	public TabularQueryFactory(TabularQueryUtils tabularQueryUtils) {
		this.tabularQueryUtils = tabularQueryUtils;
	}

	public TabularQuery get(Table table) {
		return new TabularQueryImpl(tabularQueryUtils, table);
	}

}
