package org.gcube.data.analysis.tabulardata.query;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLResultSetIterator implements Iterator<String[]> {

	Logger log = LoggerFactory.getLogger(SQLResultSetIterator.class);

	ResultSet rs;

	public SQLResultSetIterator(ResultSet rs) {
		super();
		this.rs = rs;
	}

	@Override
	public boolean hasNext() {
		
		try {
			return !rs.isLast();
		} catch (SQLException e) {
			throw new RuntimeException("Unable to read query result from DB. Check server logs.");
		}
	}

	@Override
	public String[] next() {
		boolean valid;
		int numCols;
			try {
				valid = rs.next();
				numCols = rs.getMetaData().getColumnCount();
				if (!valid)
					return null;
				String[] result = new String[numCols];
				for (int i = 0; i < numCols; i++)
					result[i] = rs.getString(i + 1);
				return result;
			} catch (SQLException e) {
				log.error("Unable to read row",e);
				throw new RuntimeException("Unable to read result row. Check server error.");
			}
	}

	@Override
	public void remove() {
		throw new UnsupportedOperationException("Remove operations is unsupported.");
	}

}
