/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.model.resources;

import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.gcube.data.analysis.tabulardata.model.resources.Resource;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class SDMXResource
extends Resource {
    private static final long serialVersionUID = -8695994802487301542L;
    private String version;
    private String agency;
    private String primaryMeasure;
    private String name;
    private URL registryURL;
    private TYPE type;

    public SDMXResource() {
    }

    public SDMXResource(URL registryURL, String name, String version, String agency, String primaryMeasure, TYPE type) {
        this.registryURL = registryURL;
        this.name = name;
        this.version = version;
        this.agency = agency;
        this.primaryMeasure = primaryMeasure;
        this.type = type;
    }

    public SDMXResource(URL registryURL, String name, String version, String agency, TYPE type) {
        this(registryURL, name, version, agency, null, type);
    }

    @Override
    public String getStringValue() {
        String registryUrlString = this.registryURL.toString();
        StringBuilder resourceURL = new StringBuilder(registryUrlString);
        if (!registryUrlString.endsWith("/")) {
            resourceURL.append("/");
        }
        resourceURL.append(this.type.toStringUrl()).append("/").append(this.agency).append("/").append(this.name).append("/").append(this.version);
        return resourceURL.toString();
    }

    public URL getResourceURL() {
        try {
            return new URL(this.getStringValue());
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public String getVersion() {
        return this.version;
    }

    public String getAgency() {
        return this.agency;
    }

    public String getPrimaryMeasure() {
        return this.primaryMeasure;
    }

    public String getName() {
        return this.name;
    }

    public TYPE getType() {
        return this.type;
    }

    @Override
    public Class<? extends Resource> getResourceType() {
        return this.getClass();
    }

    public URL getRegistryURL() {
        return this.registryURL;
    }

    public boolean equals(Object sdmxResource) {
        if (sdmxResource instanceof SDMXResource) {
            SDMXResource sdmx = (SDMXResource)sdmxResource;
            return this.checkEqual(this.registryURL, sdmx.getRegistryURL()) && this.checkEqual(this.name, sdmx.getName()) && this.checkEqual(this.agency, sdmx.getAgency()) && this.checkEqual(this.primaryMeasure, sdmx.getPrimaryMeasure()) && this.checkEqual((Object)this.type, (Object)sdmx.getType()) && this.checkEqual(this.version, sdmx.getVersion());
        }
        return super.equals(sdmxResource);
    }

    private boolean checkEqual(Object object1, Object object2) {
        return object1 == null && object2 == null || object1 != null && object1.equals(object2);
    }

    public String toString() {
        StringBuilder toStringBuilder = new StringBuilder("SDMX Resource [");
        toStringBuilder.append((Object)this.type).append(", ").append(this.name).append(", ").append(this.version).append(", agency ").append(this.agency);
        if (this.primaryMeasure != null) {
            toStringBuilder.append(", primary measure ").append(this.primaryMeasure);
        }
        toStringBuilder.append(", Registry URL ").append(this.registryURL).append("]");
        return toStringBuilder.toString();
    }

    public static enum TYPE {
        DATA_STRUCTURE("DataStructure"),
        CODE_LIST("CodeList");

        private String type;

        private TYPE(String type) {
            this.type = type;
        }

        public String toString() {
            return this.type;
        }

        public String toStringUrl() {
            return this.type.toLowerCase();
        }
    }
}

