/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.model.resources;

import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.gcube.data.analysis.tabulardata.model.resources.Resource;
import org.gcube.data.analysis.tabulardata.model.resources.Thumbnail;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class InternalURI
extends Resource {
    private static final long serialVersionUID = -3230438212164027113L;
    private String fileId;
    private URI uri;
    private String mimeType;
    private Thumbnail thumbnail;

    private InternalURI() {
    }

    public InternalURI(URI uri) {
        this.uri = uri;
    }

    public InternalURI(URI uri, String mimeType) {
        this(uri);
        this.mimeType = mimeType;
    }

    public InternalURI(URI uri, String mimeType, Thumbnail thumbnail) {
        this(uri, mimeType);
        this.thumbnail = thumbnail;
    }

    public URI getUri() {
        if (this.uri != null) {
            return this.uri;
        }
        try {
            return new URI(this.fileId);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getStringValue() {
        if (this.uri != null) {
            return this.uri.toString();
        }
        return this.fileId;
    }

    @Override
    public Class<? extends Resource> getResourceType() {
        return this.getClass();
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public Thumbnail getThumbnail() {
        return this.thumbnail;
    }
}

