/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.expression.composite.text;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.gcube.data.analysis.tabulardata.expression.Expression;
import org.gcube.data.analysis.tabulardata.expression.MalformedExpressionException;
import org.gcube.data.analysis.tabulardata.expression.NotEvaluableDataTypeException;
import org.gcube.data.analysis.tabulardata.expression.Operator;
import org.gcube.data.analysis.tabulardata.expression.composite.CompositeExpression;
import org.gcube.data.analysis.tabulardata.expression.composite.text.TextExpression;
import org.gcube.data.analysis.tabulardata.expression.leaf.LeafExpression;
import org.gcube.data.analysis.tabulardata.model.datatype.DataType;
import org.gcube.data.analysis.tabulardata.model.datatype.IntegerType;
import org.gcube.data.analysis.tabulardata.model.datatype.TextType;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class RepeatText
extends CompositeExpression
implements TextExpression {
    private static final long serialVersionUID = 2210765202980244382L;
    Expression times;
    Expression value;

    protected RepeatText() {
    }

    public RepeatText(Expression value, Expression repeatTimes) {
        this.times = repeatTimes;
        this.value = value;
    }

    @Override
    public Operator getOperator() {
        return Operator.REPEAT_TEXT;
    }

    public Expression getTimes() {
        return this.times;
    }

    public Expression getValue() {
        return this.value;
    }

    @Override
    public void validate() throws MalformedExpressionException {
        if (this.value == null) {
            throw new MalformedExpressionException("value cannot be null. " + this);
        }
        if (this.times == null) {
            throw new MalformedExpressionException("repeat times cannot be null. " + this);
        }
        this.value.validate();
        this.times.validate();
        try {
            DataType sourceType = this.value.getReturnedDataType();
            if (!(sourceType instanceof TextType)) {
                throw new MalformedExpressionException("value expression must return string type. Returned Type is " + sourceType.getName() + "." + this);
            }
        }
        catch (NotEvaluableDataTypeException e) {
            // empty catch block
        }
        try {
            DataType fromType = this.times.getReturnedDataType();
            if (!(fromType instanceof IntegerType)) {
                throw new MalformedExpressionException("RepeatTimes expression must return integer type. Returned Type is " + fromType.getName() + "." + this);
            }
        }
        catch (NotEvaluableDataTypeException notEvaluableDataTypeException) {
            // empty catch block
        }
    }

    @Override
    public DataType getReturnedDataType() throws NotEvaluableDataTypeException {
        return new TextType();
    }

    @Override
    public List<Expression> getLeavesByType(Class<? extends LeafExpression> type) {
        ArrayList<Expression> toReturn = new ArrayList<Expression>();
        if (type.isInstance(this.times)) {
            toReturn.add(this.times);
        } else {
            toReturn.addAll(this.times.getLeavesByType(type));
        }
        if (type.isInstance(this.value)) {
            toReturn.add(this.value);
        } else {
            toReturn.addAll(this.value.getLeavesByType(type));
        }
        return toReturn;
    }

    public String toString() {
        return "RepeatText [times=" + this.times + ", value=" + this.value + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.times == null ? 0 : this.times.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RepeatText other = (RepeatText)obj;
        if (this.times == null ? other.times != null : !this.times.equals(other.times)) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }
}

