package org.gcube.data.analysis.tabulardata.model.time;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public enum PeriodType {
	DAY("Day", "select get_day_id(i), normalize_day(i), to_char(i, 'DD Mon YYYY') from generate_series('</START>-01-01','</END>-12-31', '1 day'::interval) i;"), 
	MONTH("Month", "select get_month_id(i), normalize_month(i), to_char(i, 'Mon YYYY') from generate_series('</START>-01-01','</END>-12-31', '1 month'::interval) i"), 
	QUARTER("Quarter_of_year", "select get_quarter_of_year_id(i), normalize_quarter_of_year(i), to_char(i, 'Qth \"Q\"uarter of YYYY') from generate_series('</START>-01-01','</END>-12-31', '3 month'::interval) i;"), 
	YEAR("Year",  "select get_year_id(i), normalize_year(i), to_char(i, 'YYYY') from generate_series('</START>-01-01','</END>-12-31', '1 year'::interval) i");

	private static final int START_YEAR = 1700;
	
	private static final int END_YEAR = 2300;
	
	private static Map<PeriodType, List<PeriodType>> hierarchicalRelation = new HashMap<>();
	
	static {
		hierarchicalRelation.put(DAY, Arrays.asList(MONTH, QUARTER, YEAR));
		hierarchicalRelation.put(MONTH, Arrays.asList(QUARTER, YEAR));
		hierarchicalRelation.put(QUARTER, Arrays.asList(YEAR));
	}
	
	private String name;
	//private Class<? extends DataType>  valueType;
	private String seriesSelectQuery;
	
	private PeriodType(String name, String seriesSelectQuery) {
		this.name = name;
		this.seriesSelectQuery = seriesSelectQuery;
	}

	public String getName() {
		return name;
	}
	
	/*public Class<? extends DataType> getValueType() {
		return valueType;
	}*/

	public static PeriodType fromName(String name) {
		for (PeriodType periodType : PeriodType.values()) {
			if (name.equals(periodType.getName()))
				return periodType;
		}
		return null;
	}
	
	public String getSeriesSelectQuery() {
		return seriesSelectQuery.replaceAll("</START>", START_YEAR+"").replaceAll("</END>", END_YEAR+"");
	}

	public static Map<PeriodType, List<PeriodType>> getHierarchicalRelation(){
		return hierarchicalRelation;
	}
}