/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.expression.composite.text;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.gcube.data.analysis.tabulardata.expression.Expression;
import org.gcube.data.analysis.tabulardata.expression.MalformedExpressionException;
import org.gcube.data.analysis.tabulardata.expression.Operator;
import org.gcube.data.analysis.tabulardata.expression.composite.CompositeExpression;
import org.gcube.data.analysis.tabulardata.model.datatype.DataType;
import org.gcube.data.analysis.tabulardata.model.datatype.TextType;
import org.gcube.data.analysis.tabulardata.model.datatype.value.TDText;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class TextReplaceMatchingRegex
extends CompositeExpression {
    private static final long serialVersionUID = 8463250380703209101L;
    private Expression toCheckText;
    private TDText regexp;
    private TDText replacingValue;
    private boolean caseSensitive = false;

    @Override
    public Operator getOperator() {
        return Operator.REPLACE_REGEX;
    }

    @Override
    public DataType getReturnedDataType() {
        return new TextType();
    }

    private TextReplaceMatchingRegex() {
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public TextReplaceMatchingRegex(Expression toCheckText, TDText regexp, TDText replacing) {
        this.toCheckText = toCheckText;
        this.regexp = regexp;
        this.replacingValue = replacing;
    }

    public TextReplaceMatchingRegex(Expression toCheckText, TDText regexp, TDText replacing, boolean caseSensitive) {
        this.toCheckText = toCheckText;
        this.regexp = regexp;
        this.replacingValue = replacing;
        this.caseSensitive = caseSensitive;
    }

    @Override
    public void validate() throws MalformedExpressionException {
        if (this.toCheckText == null) {
            throw new MalformedExpressionException("To check text cannot be null. " + this);
        }
        if (this.regexp == null) {
            throw new MalformedExpressionException("Regexp value cannot be null." + this);
        }
        if (this.replacingValue == null) {
            throw new MalformedExpressionException("To set value cannot be null." + this);
        }
        this.toCheckText.validate();
        this.regexp.validate();
        this.replacingValue.validate();
    }

    public Expression getToCheckText() {
        return this.toCheckText;
    }

    public void setToCheckText(Expression toCheckText) {
        this.toCheckText = toCheckText;
    }

    public TDText getRegexp() {
        return this.regexp;
    }

    public void setRegexp(TDText regexp) {
        this.regexp = regexp;
    }

    public TDText getReplacingValue() {
        return this.replacingValue;
    }

    public void setReplacingValue(TDText replacingValue) {
        this.replacingValue = replacingValue;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("TextReplaceMatchingRegex [toCheckText=");
        builder.append(this.toCheckText);
        builder.append(", regexp=");
        builder.append(this.regexp);
        builder.append(", replacingValue=");
        builder.append(this.replacingValue);
        builder.append(", caseSensitive=");
        builder.append(this.caseSensitive);
        builder.append("]");
        return builder.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.caseSensitive ? 1231 : 1237);
        result = 31 * result + (this.regexp == null ? 0 : this.regexp.hashCode());
        result = 31 * result + (this.replacingValue == null ? 0 : this.replacingValue.hashCode());
        result = 31 * result + (this.toCheckText == null ? 0 : this.toCheckText.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TextReplaceMatchingRegex other = (TextReplaceMatchingRegex)obj;
        if (this.caseSensitive != other.caseSensitive) {
            return false;
        }
        if (this.regexp == null ? other.regexp != null : !this.regexp.equals(other.regexp)) {
            return false;
        }
        if (this.replacingValue == null ? other.replacingValue != null : !this.replacingValue.equals(other.replacingValue)) {
            return false;
        }
        return !(this.toCheckText == null ? other.toCheckText != null : !this.toCheckText.equals(other.toCheckText));
    }
}

