/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.model.metadata.common;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.gcube.data.analysis.tabulardata.model.metadata.common.LocalizedText;
import org.gcube.data.analysis.tabulardata.model.metadata.common.LocalizedTextHolder;

public class ImmutableLocalizedTextHolder
implements LocalizedTextHolder,
Serializable {
    private static final long serialVersionUID = -7435564643334923290L;
    protected List<LocalizedText> texts = new ArrayList<LocalizedText>();

    protected ImmutableLocalizedTextHolder() {
    }

    public ImmutableLocalizedTextHolder(List<LocalizedText> texts) {
        for (LocalizedText localizedText : texts) {
            LocalizedText textWithSameLocale = this.getTextWithLocale(localizedText.getLocale());
            if (textWithSameLocale != null) {
                this.texts.remove(textWithSameLocale);
            }
            this.texts.add(localizedText);
        }
    }

    public ImmutableLocalizedTextHolder(Set<LocalizedText> texts) {
        this.texts = new ArrayList<LocalizedText>(texts);
    }

    @Override
    public List<LocalizedText> getTexts() {
        return Collections.unmodifiableList(this.texts);
    }

    @Override
    public boolean hasTextWithLocale(String locale) {
        return this.getTextWithLocale(locale) != null;
    }

    @Override
    public LocalizedText getTextWithLocale(String locale) {
        for (LocalizedText text : this.texts) {
            if (!text.getLocale().equals(locale)) continue;
            return text;
        }
        return null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.texts == null ? 0 : this.texts.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ImmutableLocalizedTextHolder other = (ImmutableLocalizedTextHolder)obj;
        return !(this.texts == null ? other.texts != null : !this.texts.equals(other.texts));
    }
}

