package org.gcube.data.analysis.tabulardata.expression.composite.text;

import java.util.ArrayList;
import java.util.List;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;

import org.gcube.data.analysis.tabulardata.expression.Expression;
import org.gcube.data.analysis.tabulardata.expression.ExpressionCategory;
import org.gcube.data.analysis.tabulardata.expression.composite.BinaryExpression;
import org.gcube.data.analysis.tabulardata.model.datatype.DataType;
import org.gcube.data.analysis.tabulardata.model.datatype.TextType;
@XmlAccessorType(XmlAccessType.FIELD)
public abstract class TextExpression extends BinaryExpression implements ExpressionCategory{

	/**
	 * 
	 */
	private static final long serialVersionUID = 1038382757016138183L;

	private static final List<Class<? extends DataType>> allowedTypes=new ArrayList<Class<? extends DataType>>();
	
	
	private boolean caseSensitive=true;
	
	static {
		allowedTypes.add(TextType.class);
	}
	
	protected TextExpression() {
		super();
	}

	protected TextExpression(Expression leftArgument, Expression rightArgument) {
		super(leftArgument, rightArgument);
	}

	protected TextExpression(Expression leftArgument,Expression rightArgument,boolean caseSensitive){
		this(leftArgument,rightArgument);
		this.caseSensitive=caseSensitive;
	}
	
	@Override
	public List<Class<? extends DataType>> allowedLeftDataTypes() {
				return allowedTypes;
	}
	
	@Override
	public List<Class<? extends DataType>> allowedRightDataTypes() {
		return allowedTypes;
	}
	
	public boolean isCaseSensitive() {
		return caseSensitive;
	}
	
	public void setCaseSensitive(boolean caseSensitive) {
		this.caseSensitive = caseSensitive;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#hashCode()
	 */
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = super.hashCode();
		result = prime * result + (caseSensitive ? 1231 : 1237);
		return result;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (!super.equals(obj))
			return false;
		if (getClass() != obj.getClass())
			return false;
		TextExpression other = (TextExpression) obj;
		if (caseSensitive != other.caseSensitive)
			return false;
		return true;
	}
	
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("TextExpression [");
		builder.append(getLeftArgument()+" ");
		builder.append(getOperator()+" ");
		builder.append(isCaseSensitive()?"CS ":"CI");
		builder.append(getRightArgument());
		builder.append("]");
		return builder.toString();
	}
}
