package org.gcube.data.analysis.tabulardata.expression.composite.aggregation;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;

import org.gcube.data.analysis.tabulardata.expression.Expression;
import org.gcube.data.analysis.tabulardata.expression.NotEvaluableDataTypeException;
import org.gcube.data.analysis.tabulardata.expression.Operator;
import org.gcube.data.analysis.tabulardata.expression.composite.UnaryExpression;
import org.gcube.data.analysis.tabulardata.model.datatype.DataType;
import org.gcube.data.analysis.tabulardata.model.datatype.IntegerType;
@XmlRootElement
@XmlAccessorType(XmlAccessType.FIELD)
public class Count extends UnaryExpression implements AggregationExpression {

	/**
	 * 
	 */
	private static final long serialVersionUID = -5043963811568398617L;

	@SuppressWarnings("unused")
	private Count() {
	}
	
	
	
	public Count(Expression argument) {
		super(argument);
	}



	@Override
	public Operator getOperator() {
		return Operator.COUNT;
	}

	@Override
	public DataType getReturnedDataType() throws NotEvaluableDataTypeException {
		return new IntegerType();
	}

}
