/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.expression;

import org.gcube.data.analysis.tabulardata.expression.composite.CompositeExpression;
import org.gcube.data.analysis.tabulardata.expression.composite.ExternalReferenceExpression;
import org.gcube.data.analysis.tabulardata.expression.composite.aggregation.Avg;
import org.gcube.data.analysis.tabulardata.expression.composite.aggregation.Count;
import org.gcube.data.analysis.tabulardata.expression.composite.aggregation.First;
import org.gcube.data.analysis.tabulardata.expression.composite.aggregation.Last;
import org.gcube.data.analysis.tabulardata.expression.composite.aggregation.Max;
import org.gcube.data.analysis.tabulardata.expression.composite.aggregation.Min;
import org.gcube.data.analysis.tabulardata.expression.composite.aggregation.Sum;
import org.gcube.data.analysis.tabulardata.expression.composite.arithmetic.Addition;
import org.gcube.data.analysis.tabulardata.expression.composite.arithmetic.Division;
import org.gcube.data.analysis.tabulardata.expression.composite.arithmetic.Modulus;
import org.gcube.data.analysis.tabulardata.expression.composite.arithmetic.Multiplication;
import org.gcube.data.analysis.tabulardata.expression.composite.arithmetic.Subtraction;
import org.gcube.data.analysis.tabulardata.expression.composite.comparable.Equals;
import org.gcube.data.analysis.tabulardata.expression.composite.comparable.GreaterOrEquals;
import org.gcube.data.analysis.tabulardata.expression.composite.comparable.GreaterThan;
import org.gcube.data.analysis.tabulardata.expression.composite.comparable.LessOrEquals;
import org.gcube.data.analysis.tabulardata.expression.composite.comparable.LessThan;
import org.gcube.data.analysis.tabulardata.expression.composite.comparable.NotEquals;
import org.gcube.data.analysis.tabulardata.expression.composite.comparable.NotGreater;
import org.gcube.data.analysis.tabulardata.expression.composite.comparable.NotLess;
import org.gcube.data.analysis.tabulardata.expression.composite.text.Concat;
import org.gcube.data.analysis.tabulardata.expression.composite.text.Length;
import org.gcube.data.analysis.tabulardata.expression.composite.text.Lower;
import org.gcube.data.analysis.tabulardata.expression.composite.text.MD5;
import org.gcube.data.analysis.tabulardata.expression.composite.text.SubstringByIndex;
import org.gcube.data.analysis.tabulardata.expression.composite.text.SubstringByRegex;
import org.gcube.data.analysis.tabulardata.expression.composite.text.SubstringPosition;
import org.gcube.data.analysis.tabulardata.expression.composite.text.TextBeginsWith;
import org.gcube.data.analysis.tabulardata.expression.composite.text.TextContains;
import org.gcube.data.analysis.tabulardata.expression.composite.text.TextEndsWith;
import org.gcube.data.analysis.tabulardata.expression.composite.text.TextMatchSQLRegexp;
import org.gcube.data.analysis.tabulardata.expression.composite.text.TextReplaceMatchingRegex;
import org.gcube.data.analysis.tabulardata.expression.composite.text.Trim;
import org.gcube.data.analysis.tabulardata.expression.composite.text.Upper;
import org.gcube.data.analysis.tabulardata.expression.functions.Cast;
import org.gcube.data.analysis.tabulardata.expression.logical.And;
import org.gcube.data.analysis.tabulardata.expression.logical.Between;
import org.gcube.data.analysis.tabulardata.expression.logical.IsNotNull;
import org.gcube.data.analysis.tabulardata.expression.logical.IsNull;
import org.gcube.data.analysis.tabulardata.expression.logical.Not;
import org.gcube.data.analysis.tabulardata.expression.logical.Or;
import org.gcube.data.analysis.tabulardata.expression.logical.ValueIsIn;

public enum Operator {
    ADDITION(Addition.class, "Addition", "+"),
    SUBTRACTION(Subtraction.class, "Subtraction", "-"),
    MULTIPLICATION(Multiplication.class, "Multiplication", "*"),
    DIVISION(Division.class, "Division", "/"),
    MODULUS(Modulus.class, "Modulus", "%"),
    EQUALS(Equals.class, "Equals", "="),
    GREATER(GreaterThan.class, "Greater than", ">"),
    LESSER(LessThan.class, "Less than", "<"),
    GREATER_OR_EQUALS(GreaterOrEquals.class, "Greater or equals", ">="),
    LESSER_OR_EQUALS(LessOrEquals.class, "Less or equals", "<="),
    NOT_EQUALS(NotEquals.class, "Not Equals", "!="),
    NOT_GREATER(NotGreater.class, "Not Greater", "!>"),
    NOT_LESSER(NotLess.class, "Not Less", "!<"),
    AND(And.class, "And", "&"),
    BETWEEN(Between.class, "Between", "[..]"),
    IN(ValueIsIn.class, "In", "IN"),
    NOT(Not.class, "Not", "!"),
    OR(Or.class, "Or", "|"),
    IS_NULL(IsNull.class, "Is Null", "Is Null"),
    IS_NOT_NULL(IsNotNull.class, "Is Not Null", "Is Not Null"),
    BEGINS_WITH(TextBeginsWith.class, "Begins with", "XXX*"),
    ENDS_WITH(TextEndsWith.class, "Ends with", "*XXX"),
    CONTAINS(TextContains.class, "Contains", "*XXX*"),
    MATCH_REGEX(TextMatchSQLRegexp.class, "Match Regex", "Match_Regex"),
    REPLACE_REGEX(TextReplaceMatchingRegex.class, "Replace By Regex", "Replace By Regex"),
    SUBSTRING_BY_REGEX(SubstringByRegex.class, "Substring By Regex", "Substring By Regex"),
    SUBSTRING_BY_INDEX(SubstringByIndex.class, "Substring By Index", "Substring By Index"),
    SUBSTRING_POSITION(SubstringPosition.class, "Substring Position", "Pos"),
    TRIM(Trim.class, "Trim", "Trim"),
    LENGTH(Length.class, "Length", "Length"),
    UPPER(Upper.class, "Uppercase", "UpCase"),
    LOWER(Lower.class, "Lowercase", "LowCase"),
    CONCAT(Concat.class, "Concat", "Concat"),
    MD5(MD5.class, "MD5", "MD5"),
    SELECT_IN(ExternalReferenceExpression.class, "Select IN", "Select IN"),
    CAST(Cast.class, "Cast", "Cast"),
    AVG(Avg.class, "Average", "AVG"),
    COUNT(Count.class, "Count", "Count"),
    FIRST(First.class, "First", "First"),
    LAST(Last.class, "Last", "Last"),
    MAX(Max.class, "Max", "Max"),
    MIN(Min.class, "Min", "Min"),
    SUM(Sum.class, "Sum", "Sum");

    private Class<? extends CompositeExpression> implementingClass;
    private String label;
    private String symbol;

    private Operator(Class<? extends CompositeExpression> implementingClass, String label, String symbol) {
        this.implementingClass = implementingClass;
        this.label = label;
        this.symbol = symbol;
    }

    public static final Operator getByExpressionClass(Class<? extends CompositeExpression> clazz) {
        for (Operator op : Operator.values()) {
            if (!op.getImplementingClass().equals(clazz)) continue;
            return op;
        }
        throw new RuntimeException("Unable to find an operator for class " + clazz);
    }

    public Class<? extends CompositeExpression> getImplementingClass() {
        return this.implementingClass;
    }

    public String getLabel() {
        return this.label;
    }

    public String getSymbol() {
        return this.symbol;
    }
}

