package org.gcube.data.analysis.tabulardata.model.metadata.table;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

import org.gcube.data.analysis.tabulardata.model.column.ColumnLocalId;
import org.gcube.data.analysis.tabulardata.model.metadata.common.ImmutableLocalizedText;
import org.gcube.data.analysis.tabulardata.model.metadata.common.LocalizedText;


@XmlRootElement(name="GlobalValidationReportMetadata")
@XmlAccessorType(XmlAccessType.FIELD)
public class GlobalDataValidationReportMetadata implements TableMetadata {

	private static final long serialVersionUID = 5346249544710409540L;

	@XmlElement(type=ImmutableLocalizedText.class)
	private LocalizedText description;
	
	@XmlElement(type=ImmutableLocalizedText.class)
	private LocalizedText name;
	
	private int invalidRowsCount;
	
	private ColumnLocalId validationColumnId;
	
	
	@SuppressWarnings("unused")
	private GlobalDataValidationReportMetadata() {
	}
	
	
	public GlobalDataValidationReportMetadata(LocalizedText description,
			LocalizedText name, int invalidRowsCount,
			ColumnLocalId validationColumnId) {
		super();
		this.description = description;
		this.name = name;
		this.invalidRowsCount = invalidRowsCount;
		this.validationColumnId = validationColumnId;
	}

	@Override
	public boolean isInheritable() {		
		return false;
	}


	/**
	 * @return the description
	 */
	public LocalizedText getDescription() {
		return description;
	}


	/**
	 * @return the name
	 */
	public LocalizedText getName() {
		return name;
	}


	/**
	 * @return the invalidRowsCount
	 */
	public int getInvalidRowsCount() {
		return invalidRowsCount;
	}


	/**
	 * @return the validationColumnId
	 */
	public ColumnLocalId getValidationColumnId() {
		return validationColumnId;
	}
	
	public boolean isValid() {
		return invalidRowsCount==0;
	}


	/* (non-Javadoc)
	 * @see java.lang.Object#hashCode()
	 */
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result
				+ ((description == null) ? 0 : description.hashCode());
		result = prime * result + invalidRowsCount;
		result = prime * result + ((name == null) ? 0 : name.hashCode());
		result = prime
				* result
				+ ((validationColumnId == null) ? 0 : validationColumnId
						.hashCode());
		return result;
	}


	/* (non-Javadoc)
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		GlobalDataValidationReportMetadata other = (GlobalDataValidationReportMetadata) obj;
		if (description == null) {
			if (other.description != null)
				return false;
		} else if (!description.equals(other.description))
			return false;
		if (invalidRowsCount != other.invalidRowsCount)
			return false;
		if (name == null) {
			if (other.name != null)
				return false;
		} else if (!name.equals(other.name))
			return false;
		if (validationColumnId == null) {
			if (other.validationColumnId != null)
				return false;
		} else if (!validationColumnId.equals(other.validationColumnId))
			return false;
		return true;
	}


	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("GlobalDataValidationReportMetadata [description=");
		builder.append(description);
		builder.append(", name=");
		builder.append(name);
		builder.append(", invalidRowsCount=");
		builder.append(invalidRowsCount);
		builder.append(", validationColumnId=");
		builder.append(validationColumnId);
		builder.append("]");
		return builder.toString();
	}
	
	
}
