package org.gcube.data.analysis.tabulardata.expression.composite;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;

import org.gcube.data.analysis.tabulardata.expression.Expression;
import org.gcube.data.analysis.tabulardata.expression.MalformedExpressionException;

@XmlAccessorType(XmlAccessType.FIELD)
public abstract class BinaryExpression extends CompositeExpression{

	/**
	 * 
	 */
	private static final long serialVersionUID = -1471639807654392162L;
	private Expression leftArgument=null;
	private Expression rightArgument=null;
	
	protected BinaryExpression() {}

	public BinaryExpression(Expression leftArgument, Expression rightArgument) {
		super();
		this.leftArgument = leftArgument;
		this.rightArgument = rightArgument;
	}


	public Expression getLeftArgument() {
		return leftArgument;
	}

	public void setLeftArgument(Expression leftArgument) {
		this.leftArgument = leftArgument;
	}

	public Expression getRightArgument() {
		return rightArgument;
	}

	public void setRightArgument(Expression rightArgument) {
		this.rightArgument = rightArgument;
	}
	

	/* (non-Javadoc)
	 * @see java.lang.Object#hashCode()
	 */
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result
				+ ((leftArgument == null) ? 0 : leftArgument.hashCode());
		result = prime * result
				+ ((rightArgument == null) ? 0 : rightArgument.hashCode());
		return result;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		BinaryExpression other = (BinaryExpression) obj;
		if (leftArgument == null) {
			if (other.leftArgument != null)
				return false;
		} else if (!leftArgument.equals(other.leftArgument))
			return false;
		if (rightArgument == null) {
			if (other.rightArgument != null)
				return false;
		} else if (!rightArgument.equals(other.rightArgument))
			return false;
		return true;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("BinaryExpression [");
		builder.append(leftArgument+" ");
		builder.append(getOperator()+" ");		
		builder.append(rightArgument);		
		builder.append("]");
		return builder.toString();
	}
	
	@Override
	public void validate() throws MalformedExpressionException {
		if(leftArgument==null) throw new MalformedExpressionException("Left Argument cannot be null, expression : "+this);
		if(rightArgument==null) throw new MalformedExpressionException("Right Argument cannot be null, expression : "+this);
		leftArgument.validate();
		rightArgument.validate();
	}
}
