package org.gcube.data.analysis.tabulardata.model.metadata.common;

import java.io.Serializable;
import java.util.List;
import java.util.Locale;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.google.common.collect.Lists;

public class MutableLocalizedTextHolder implements LocalizedTextHolder, Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = -129662707195171960L;

	private static Logger log = LoggerFactory.getLogger(MutableLocalizedTextHolder.class);

	private List<LocalizedText> texts = Lists.newArrayList();

	/* (non-Javadoc)
	 * @see org.gcube.data.analysis.tabulardata.model.metadata.LocalizedTextHolder#getLocalizedTexts()
	 */
	@Override
	public List<LocalizedText> getTexts() {
		return texts;
	}

	/* (non-Javadoc)
	 * @see org.gcube.data.analysis.tabulardata.model.metadata.LocalizedTextHolder#setTexts(java.util.List)
	 */
	@Override
	public void setTexts(List<LocalizedText> texts) {
		for (LocalizedText columnLabel : texts) {
			addText(columnLabel);
		}
	}

	/* (non-Javadoc)
	 * @see org.gcube.data.analysis.tabulardata.model.metadata.LocalizedTextHolder#addText(org.gcube.data.analysis.tabulardata.model.metadata.LocalizedText)
	 */
	@Override
	public void addText(LocalizedText text) {
		LocalizedText sameLocaleLabel = getTextWithLocale(text.getLocale());
		if (sameLocaleLabel != null) {
			log.warn("Replacing name: " + sameLocaleLabel + "\nwith label : " + text);
			removeText(sameLocaleLabel);
		}
		texts.add(text);
	}

	/* (non-Javadoc)
	 * @see org.gcube.data.analysis.tabulardata.model.metadata.LocalizedTextHolder#removeText(org.gcube.data.analysis.tabulardata.model.metadata.LocalizedText)
	 */
	@Override
	public void removeText(LocalizedText text) {
		texts.remove(text);
	}

	/* (non-Javadoc)
	 * @see org.gcube.data.analysis.tabulardata.model.metadata.LocalizedTextHolder#hasTextWithLocale(java.util.Locale)
	 */
	@Override
	public boolean hasTextWithLocale(Locale locale) {
		if (getTextWithLocale(locale) != null)
			return true;
		return false;
	}

	/* (non-Javadoc)
	 * @see org.gcube.data.analysis.tabulardata.model.metadata.LocalizedTextHolder#getTextWithLocale(java.util.Locale)
	 */
	@Override
	public LocalizedText getTextWithLocale(Locale locale) {
		for (LocalizedText label : texts) {
			if (label.getLocale().getLanguage().equals(locale.getLanguage()))
				return label;
		}
		return null;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((texts == null) ? 0 : texts.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		MutableLocalizedTextHolder other = (MutableLocalizedTextHolder) obj;
		if (texts == null) {
			if (other.texts != null)
				return false;
		} else if (!texts.equals(other.texts))
			return false;
		return true;
	}

	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("LocalizedTextHolder [texts=");
		builder.append(texts);
		builder.append("]");
		return builder.toString();
	}
	
	

}
