package org.gcube.data.analysis.tabulardata.model.column.factories;

import java.util.Locale;

import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.type.CodeDescriptionColumnType;
import org.gcube.data.analysis.tabulardata.model.datatype.TextType;
import org.gcube.data.analysis.tabulardata.model.metadata.column.DataLocaleMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.common.LocalizedText;
import org.gcube.data.analysis.tabulardata.model.metadata.common.NamesMetadata;

public class CodeDescriptionColumnFactory extends BaseColumnFactory{

	public static Column create(Locale dataLocale){
		Column column = create(new CodeDescriptionColumnType(), new TextType());
		column.setMetadata(new DataLocaleMetadata(dataLocale));
		NamesMetadata labelsMetadata = new NamesMetadata();
		labelsMetadata.addText(new LocalizedText("description_"+dataLocale.getLanguage(),Locale.ENGLISH));
		column.setMetadata(labelsMetadata);
		return column;
	} 
	
}
