package org.gcube.data.analysis.tabulardata.expression.leaf.comparable;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;

import org.gcube.data.analysis.tabulardata.expression.LeafExpression;
import org.gcube.data.analysis.tabulardata.model.column.ColumnReference;
import org.gcube.data.analysis.tabulardata.model.datatype.value.TDBoolean;
import org.gcube.data.analysis.tabulardata.model.datatype.value.TDDate;
import org.gcube.data.analysis.tabulardata.model.datatype.value.TDInteger;
import org.gcube.data.analysis.tabulardata.model.datatype.value.TDNumeric;
import org.gcube.data.analysis.tabulardata.model.datatype.value.TDText;
import org.gcube.data.analysis.tabulardata.model.datatype.value.TDTypeValue;

@XmlRootElement (name="Equals")
@XmlAccessorType(XmlAccessType.FIELD)
@XmlSeeAlso({TDBoolean.class, TDDate.class, TDInteger.class, TDNumeric.class, TDText.class})
public class Equals extends LeafExpression {

	private ColumnReference columnReference;
	
	private TDTypeValue comparedValue;
	
	@SuppressWarnings("unused")
	private Equals() {}

	public Equals(ColumnReference columnReference, TDInteger comparedValue) {
		super();
		this.columnReference = columnReference;
		this.comparedValue = comparedValue;
	}
	
	public Equals(ColumnReference columnReference, TDNumeric comparedValue) {
		super();
		this.columnReference = columnReference;
		this.comparedValue = comparedValue;
	}
	
	public Equals(ColumnReference columnReference, TDDate comparedValue) {
		super();
		this.columnReference = columnReference;
		this.comparedValue = comparedValue;
	}
	
	public Equals(ColumnReference columnReference, TDBoolean comparedValue) {
		super();
		this.columnReference = columnReference;
		this.comparedValue = comparedValue;
	}

	public ColumnReference getColumnReference() {
		return columnReference;
	}

	public TDTypeValue getComparedValue() {
		return comparedValue;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((columnReference == null) ? 0 : columnReference.hashCode());
		result = prime * result + ((comparedValue == null) ? 0 : comparedValue.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		Equals other = (Equals) obj;
		if (columnReference == null) {
			if (other.columnReference != null)
				return false;
		} else if (!columnReference.equals(other.columnReference))
			return false;
		if (comparedValue == null) {
			if (other.comparedValue != null)
				return false;
		} else if (!comparedValue.equals(other.comparedValue))
			return false;
		return true;
	}
	
	

}
