/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.model.relationship;

import org.gcube.data.analysis.tabulardata.model.column.ColumnLocalId;
import org.gcube.data.analysis.tabulardata.model.column.ColumnReference;
import org.gcube.data.analysis.tabulardata.model.relationship.ColumnRelationship;
import org.gcube.data.analysis.tabulardata.model.relationship.ColumnRelationshipImpl;
import org.gcube.data.analysis.tabulardata.model.relationship.TableRelationship;
import org.gcube.data.analysis.tabulardata.model.table.TableId;

public class TableRelationshipImpl
implements TableRelationship {
    private static final long serialVersionUID = 8369191690239495474L;
    private ColumnRelationship delegate;
    private ColumnReference foreignKeyColumnReference;

    public TableRelationshipImpl(TableId targetTableId, ColumnLocalId targetColumnId, TableId foreignKeyTableId, ColumnLocalId foreignKeyColumnId) {
        this.delegate = new ColumnRelationshipImpl(targetTableId, targetColumnId);
        this.foreignKeyColumnReference = new ColumnReference(foreignKeyTableId, foreignKeyColumnId);
    }

    public TableRelationshipImpl(ColumnRelationship columnRelationship, TableId foreignKeyTableId, ColumnLocalId foreignKeyColumnId) {
        this.delegate = columnRelationship;
        this.foreignKeyColumnReference = new ColumnReference(foreignKeyTableId, foreignKeyColumnId);
    }

    @Override
    public TableId getTargetTableId() {
        return this.delegate.getTargetTableId();
    }

    @Override
    public ColumnLocalId getTargetColumnId() {
        return this.delegate.getTargetColumnId();
    }

    @Override
    public TableId getForeignKeyTableId() {
        return this.foreignKeyColumnReference.getTableId();
    }

    @Override
    public ColumnLocalId getForeignKeyColumnId() {
        return this.foreignKeyColumnReference.getColumnId();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.delegate == null ? 0 : this.delegate.hashCode());
        result = 31 * result + (this.foreignKeyColumnReference == null ? 0 : this.foreignKeyColumnReference.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TableRelationshipImpl other = (TableRelationshipImpl)obj;
        if (this.delegate == null ? other.delegate != null : !this.delegate.equals(other.delegate)) {
            return false;
        }
        return !(this.foreignKeyColumnReference == null ? other.foreignKeyColumnReference != null : !this.foreignKeyColumnReference.equals(other.foreignKeyColumnReference));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("TableRelationshipImpl [delegate=");
        builder.append(this.delegate);
        builder.append(", foreignKeyColumnReference=");
        builder.append(this.foreignKeyColumnReference);
        builder.append("]");
        return builder.toString();
    }
}

