/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.model.column.factories;

import org.gcube.data.analysis.tabulardata.metadata.NoSuchMetadataException;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.ColumnType;
import org.gcube.data.analysis.tabulardata.model.datatype.DataType;
import org.gcube.data.analysis.tabulardata.model.metadata.common.LocalizedText;
import org.gcube.data.analysis.tabulardata.model.metadata.common.NamesMetadata;

public class BaseColumnFactory {
    protected static Column create(ColumnType columnType, String name, LocalizedText label, DataType dataType) {
        Column result = BaseColumnFactory.create(columnType, label, dataType);
        result.setName(name);
        return result;
    }

    protected static Column create(ColumnType columnType, LocalizedText label, DataType dataType) {
        Column result = new Column(dataType, columnType);
        result.setColumnType(columnType);
        result.setDataType(dataType);
        NamesMetadata labelsMetadata = null;
        try {
            labelsMetadata = (NamesMetadata)result.getMetadata(NamesMetadata.class);
        }
        catch (NoSuchMetadataException e) {
            labelsMetadata = new NamesMetadata();
        }
        labelsMetadata.addText(label);
        result.setMetadata(labelsMetadata);
        return result;
    }

    protected static Column create(ColumnType columnType, DataType dataType) {
        return new Column(dataType, columnType);
    }
}

