package org.gcube.data.analysis.tabulardata.model.column;

import java.io.Serializable;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;

import org.gcube.data.analysis.tabulardata.model.table.TableId;

@XmlAccessorType(XmlAccessType.FIELD)
public class ColumnReference implements Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = -1322874213333736355L;

	private TableId tableId;

	private ColumnLocalId columnId;

	@SuppressWarnings("unused")
	private ColumnReference() {
	}

	public ColumnReference(TableId tableId, ColumnLocalId columnId) {
		this.tableId = tableId;
		this.columnId = columnId;
	}

	public TableId getTableId() {
		return tableId;
	}

	public void setTableId(TableId tableId) {
		this.tableId = tableId;
	}

	public ColumnLocalId getColumnId() {
		return columnId;
	}

	public void setColumnId(ColumnLocalId columnId) {
		this.columnId = columnId;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((columnId == null) ? 0 : columnId.hashCode());
		result = prime * result + ((tableId == null) ? 0 : tableId.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		ColumnReference other = (ColumnReference) obj;
		if (columnId == null) {
			if (other.columnId != null)
				return false;
		} else if (!columnId.equals(other.columnId))
			return false;
		if (tableId == null) {
			if (other.tableId != null)
				return false;
		} else if (!tableId.equals(other.tableId))
			return false;
		return true;
	}

	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("ColumnReference [tableId=");
		builder.append(tableId);
		builder.append(", columnId=");
		builder.append(columnId);
		builder.append("]");
		return builder.toString();
	}
	
	

}
