/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.model.relationship;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.ColumnLocalId;
import org.gcube.data.analysis.tabulardata.model.column.ColumnReference;
import org.gcube.data.analysis.tabulardata.model.column.type.IdColumnType;
import org.gcube.data.analysis.tabulardata.model.relationship.ColumnRelationship;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.model.table.TableId;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class ColumnRelationshipImpl
implements ColumnRelationship {
    private static final long serialVersionUID = -170595322344282579L;
    private ColumnReference targetColumnReference;

    private ColumnRelationshipImpl() {
    }

    public ColumnRelationshipImpl(TableId targetTableId, ColumnLocalId targetColumnId) {
        this.targetColumnReference = new ColumnReference(targetTableId, targetColumnId);
    }

    public ColumnRelationshipImpl(Table targetTable) {
        Column column;
        try {
            column = targetTable.getColumnsByType(IdColumnType.class).get(0);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to retrieve Id Column from table:\n" + targetTable);
        }
        this.targetColumnReference = new ColumnReference(targetTable.getId(), column.getLocalId());
    }

    @Override
    public TableId getTargetTableId() {
        return this.targetColumnReference.getTableId();
    }

    @Override
    public ColumnLocalId getTargetColumnId() {
        return this.targetColumnReference.getColumnId();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.targetColumnReference == null ? 0 : this.targetColumnReference.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ColumnRelationshipImpl other = (ColumnRelationshipImpl)obj;
        return !(this.targetColumnReference == null ? other.targetColumnReference != null : !this.targetColumnReference.equals(other.targetColumnReference));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ColumnRelationshipImpl [targetTableId()=");
        builder.append(this.getTargetTableId());
        builder.append(", targetColumnId()=");
        builder.append(this.getTargetColumnId());
        builder.append("]");
        return builder.toString();
    }
}

