/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.model.metadata.common;

import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.List;
import java.util.Locale;
import org.gcube.data.analysis.tabulardata.model.metadata.common.LocalizedText;
import org.gcube.data.analysis.tabulardata.model.metadata.common.LocalizedTextHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MutableLocalizedTextHolder
implements LocalizedTextHolder,
Serializable {
    private static final long serialVersionUID = -129662707195171960L;
    private static Logger log = LoggerFactory.getLogger(MutableLocalizedTextHolder.class);
    private List<LocalizedText> texts = Lists.newArrayList();

    @Override
    public List<LocalizedText> getTexts() {
        return this.texts;
    }

    @Override
    public void setTexts(List<LocalizedText> texts) {
        for (LocalizedText columnLabel : texts) {
            this.addText(columnLabel);
        }
    }

    @Override
    public void addText(LocalizedText text) {
        LocalizedText sameLocaleLabel = this.getTextWithLocale(text.getLocale());
        if (sameLocaleLabel != null) {
            log.warn("Replacing name: " + sameLocaleLabel + "\nwith label : " + text);
            this.removeText(sameLocaleLabel);
        }
        this.texts.add(text);
    }

    @Override
    public void removeText(LocalizedText text) {
        this.texts.remove(text);
    }

    @Override
    public boolean hasTextWithLocale(Locale locale) {
        return this.getTextWithLocale(locale) != null;
    }

    @Override
    public LocalizedText getTextWithLocale(Locale locale) {
        for (LocalizedText label : this.texts) {
            if (!label.getLocale().getLanguage().equals(locale.getLanguage())) continue;
            return label;
        }
        return null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.texts == null ? 0 : ((Object)this.texts).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MutableLocalizedTextHolder other = (MutableLocalizedTextHolder)obj;
        return !(this.texts == null ? other.texts != null : !((Object)this.texts).equals(other.texts));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("LocalizedTextHolder [texts=");
        builder.append(this.texts);
        builder.append("]");
        return builder.toString();
    }
}

