package org.gcube.data.analysis.tabulardata.model.metadata.column;

import java.util.Locale;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="DataLocaleMetadata")
@XmlAccessorType(XmlAccessType.FIELD)
public class DataLocaleMetadata implements ColumnMetadata {
	
	/**
	 * 
	 */
	private static final long serialVersionUID = -2373785745389900063L;
	
	@XmlAttribute(name="locale")
	private String localeCode;
	
	@SuppressWarnings("unused")
	private DataLocaleMetadata() {
		//Serialization only
	}

	public DataLocaleMetadata(Locale locale) {
		setLocale(locale);
	}

	public Locale getLocale() {
		return new Locale(localeCode);
	}

	public void setLocale(Locale locale) {
		this.localeCode = locale.getLanguage();
	}
	
	@Override
	public boolean isInheritable() {
		return true;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((localeCode == null) ? 0 : localeCode.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		DataLocaleMetadata other = (DataLocaleMetadata) obj;
		if (localeCode == null) {
			if (other.localeCode != null)
				return false;
		} else if (!localeCode.equals(other.localeCode))
			return false;
		return true;
	}

	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("DataLocaleMetadata [locale=");
		builder.append(localeCode);
		builder.append("]");
		return builder.toString();
	}

}
