package org.gcube.data.analysis.tabulardata.model.reference;

public class TableReferenceImpl implements TableReference {
	
	/**
	 * 
	 */
	private static final long serialVersionUID = -8231494997566498844L;

	long id;

	public TableReferenceImpl(long id) {
		super();
		this.id = id;
	}

	public long getTableId() {
		return id;
	}
	
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + (int) (id ^ (id >>> 32));
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		TableReferenceImpl other = (TableReferenceImpl) obj;
		if (id != other.id)
			return false;
		return true;
	}

	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("TableReferenceImpl [id=");
		builder.append(id);
		builder.append("]");
		return builder.toString();
	}

}
