/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.model.table;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.ColumnType;
import org.gcube.data.analysis.tabulardata.model.idioms.ColumnHasLabel;
import org.gcube.data.analysis.tabulardata.model.idioms.ColumnHasName;
import org.gcube.data.analysis.tabulardata.model.idioms.ColumnIsOfType;
import org.gcube.data.analysis.tabulardata.model.metadata.CubeMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.HashMapMetadataHolder;
import org.gcube.data.analysis.tabulardata.model.metadata.MetadataHolder;
import org.gcube.data.analysis.tabulardata.model.reference.ColumnReference;
import org.gcube.data.analysis.tabulardata.model.reference.ColumnReferenceImpl;
import org.gcube.data.analysis.tabulardata.model.reference.TableReference;
import org.gcube.data.analysis.tabulardata.model.reference.TableReferenceImpl;
import org.gcube.data.analysis.tabulardata.model.relationship.TableRelationship;
import org.gcube.data.analysis.tabulardata.model.relationship.TableRelationshipImpl;
import org.gcube.data.analysis.tabulardata.model.table.TableType;

public abstract class Table
implements MetadataHolder {
    private Long id = null;
    private String name = null;
    private MetadataHolder delegate = new HashMapMetadataHolder();
    private Long parentTableId = null;
    private boolean exists = true;

    public Table(long id, String name) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("Table name cannot be null or empty");
        }
        this.id = id;
        this.name = name;
    }

    public Table(String name) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("Table name cannot be null or empty");
        }
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public TableReference getReference() {
        return new TableReferenceImpl(this.getId());
    }

    public ColumnReference getColumnReference(Column column) {
        if (!this.getColumns().contains(column)) {
            throw new IllegalArgumentException(String.format("Column %1$s is not contained in table %2$s. Unable to produce a reference for the column.", column, this));
        }
        return new ColumnReferenceImpl(this.getReference(), column.getName());
    }

    public abstract TableType getTableType();

    public abstract List<Column> getColumns();

    public Column getColumnByName(String columnName) throws RuntimeException, IllegalArgumentException {
        Collection columns = Collections2.filter(this.getColumns(), (Predicate)new ColumnHasName(columnName));
        if (columns.size() > 1) {
            throw new RuntimeException("Found multiple column with the same name '" + columnName + "'.");
        }
        if (columns.size() == 0) {
            throw new IllegalArgumentException("No column found with name '" + columnName + "'.");
        }
        return (Column)columns.iterator().next();
    }

    public Column getColumnByLabel(String columnLabel) throws RuntimeException, IllegalArgumentException {
        Collection columns = Collections2.filter(this.getColumns(), (Predicate)new ColumnHasLabel(columnLabel));
        if (columns.size() > 1) {
            throw new RuntimeException("Found multiple column with the same label '" + columnLabel + "'.");
        }
        if (columns.size() == 0) {
            throw new IllegalArgumentException("No column found with label '" + columnLabel + "'.");
        }
        return (Column)columns.iterator().next();
    }

    public List<Column> getColumns(ColumnType columnType) {
        return Lists.newArrayList((Iterable)Collections2.filter(this.getColumns(), (Predicate)new ColumnIsOfType(columnType)));
    }

    public List<Column> getColumns(ColumnType ... columnTypes) {
        ArrayList result = Lists.newArrayList();
        for (ColumnType columnType : columnTypes) {
            result.addAll(Collections2.filter(this.getColumns(), (Predicate)new ColumnIsOfType(columnType)));
        }
        return result;
    }

    public boolean hasRelationships() {
        for (Column column : this.getColumns()) {
            if (!column.hasRelationship()) continue;
            return true;
        }
        return false;
    }

    public Collection<TableRelationship> getRelationships() {
        ArrayList result = Lists.newArrayList();
        for (Column column : this.getColumns()) {
            if (!column.hasRelationship()) continue;
            result.add(new TableRelationshipImpl(new ColumnReferenceImpl(this.getId(), column.getName()), column.getRelationship()));
        }
        return result;
    }

    public boolean sameStructureAs(Table table) {
        if (!this.name.equals(table.getName())) {
            return false;
        }
        if (!this.getTableType().equals((Object)table.getTableType())) {
            return false;
        }
        for (Column column : this.getColumns()) {
            if (table.getColumns().contains(column)) continue;
            return false;
        }
        for (Column column : table.getColumns()) {
            if (this.getColumns().contains(column)) continue;
            return false;
        }
        return true;
    }

    public Long getParentTableId() {
        return this.parentTableId;
    }

    public void setParentTableId(Long parentTableId) {
        this.parentTableId = parentTableId;
    }

    public boolean exists() {
        return this.exists;
    }

    public void setExists(boolean exists) {
        this.exists = exists;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.delegate == null ? 0 : this.delegate.hashCode());
        result = 31 * result + (this.exists ? 1231 : 1237);
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.parentTableId == null ? 0 : this.parentTableId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Table other = (Table)obj;
        if (this.delegate == null ? other.delegate != null : !this.delegate.equals(other.delegate)) {
            return false;
        }
        if (this.exists != other.exists) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.parentTableId == null ? other.parentTableId != null : !this.parentTableId.equals(other.parentTableId));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Table [getId()=");
        builder.append(this.getId());
        builder.append(", getTableType()=");
        builder.append((Object)this.getTableType());
        builder.append(", getName()=");
        builder.append(this.getName());
        builder.append(", exists()=");
        builder.append(this.exists());
        builder.append(", getParentTableId()=");
        builder.append(this.getParentTableId());
        builder.append(", getAllMetadata()=");
        builder.append(this.getAllMetadata());
        builder.append(", getColumns()=\n");
        for (Column column : this.getColumns()) {
            builder.append("\t" + column + "\n");
        }
        builder.append(", getRelationships()=");
        builder.append(this.getRelationships());
        builder.append("]");
        return builder.toString();
    }

    @Override
    public <C extends CubeMetadata<? extends Serializable>> C getMetadata(Class<C> metadataType) {
        return this.delegate.getMetadata(metadataType);
    }

    @Override
    public void removeMetadata(Class<? extends CubeMetadata<? extends Serializable>> metadataType) {
        this.delegate.removeMetadata(metadataType);
    }

    @Override
    public void setMetadata(CubeMetadata<? extends Serializable> metadata) {
        this.delegate.setMetadata(metadata);
    }

    @Override
    public Collection<CubeMetadata<Serializable>> getAllMetadata() {
        return this.delegate.getAllMetadata();
    }

    @Override
    public void removeAllMetadata() {
        this.delegate.removeAllMetadata();
    }

    @Override
    public void setMetadata(Collection<? extends CubeMetadata<? extends Serializable>> metadataObjects) {
        this.delegate.setMetadata(metadataObjects);
    }

    @Override
    public <T extends Serializable> T getMetadataObject(Class<? extends CubeMetadata<T>> metadataType) {
        return this.delegate.getMetadataObject(metadataType);
    }
}

