package org.gcube.data.analysis.tabulardata.model.table;

import java.util.Collection;
import java.util.List;

import org.gcube.data.analysis.tabulardata.model.column.Column;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;

public class ViewTable extends Table{
	
	private Collection<Column> columns = Lists.newArrayList();

	public ViewTable(long id, String name, Collection<Column> columns) {
		super(id, name);
		this.columns.addAll(columns);
	}
	
	public ViewTable(String name, Collection<Column> columns) {
		super(name);
		this.columns.addAll(columns);
	}

	@Override
	public TableType getTableType() {
		return TableType.VIEWTABLE;
	}

	@Override
	public List<Column> getColumns() {
		return ImmutableList.copyOf(columns);
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = super.hashCode();
		result = prime * result + ((columns == null) ? 0 : columns.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (!super.equals(obj))
			return false;
		if (getClass() != obj.getClass())
			return false;
		ViewTable other = (ViewTable) obj;
		if (columns == null) {
			if (other.columns != null)
				return false;
		} else if (!columns.equals(other.columns))
			return false;
		return true;
	}

}
