package org.gcube.data.analysis.tabulardata.model.table;

import java.util.Collection;
import java.util.List;

import org.gcube.data.analysis.tabulardata.model.column.CodelistRefColumn;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.IdColumn;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;

/**
 * Represent a HierarchicalCodelist that enables a parent-child relationship
 * between codes of two codelist. By using hierarchical codelist one child code
 * can have multiple parent codes. A hierachical codelist is made of one
 * {@link IdColumn}, a parent code {@link CodelistRefColumn}, a child code
 * {@link CodelistRefColumn}
 * 
 * @author "Luigi Fortunati"
 * 
 */
public class HierarchicalCodelist extends Table {

	private List<Column> columns;

	public HierarchicalCodelist(HierarchicalCodelist hcl) {
		super(hcl.getId(), hcl.getName());
		columns = Lists.newArrayList(hcl.getColumns());
	}

	public HierarchicalCodelist(long id, String name, Collection<Column> columns) {
		super(id, name);
		this.columns = Lists.newArrayList(columns);
	}
	
	public HierarchicalCodelist(String name, Collection<Column> columns) {
		super(name);
		this.columns = Lists.newArrayList(columns);
	}

	@Override
	public List<Column> getColumns() {
		return ImmutableList.copyOf(columns);
	}

	@Override
	public TableType getTableType() {
		return TableType.HIERARCHICALCODELIST;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = super.hashCode();
		result = prime * result + ((columns == null) ? 0 : columns.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (!super.equals(obj))
			return false;
		if (getClass() != obj.getClass())
			return false;
		HierarchicalCodelist other = (HierarchicalCodelist) obj;
		if (columns == null) {
			if (other.columns != null)
				return false;
		} else if (!columns.equals(other.columns))
			return false;
		return true;
	}

}
