/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.model.column;

import com.google.common.base.Optional;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.ColumnType;
import org.gcube.data.analysis.tabulardata.model.datatype.DataType;
import org.gcube.data.analysis.tabulardata.model.relationship.ColumnRelationship;
import org.gcube.data.analysis.tabulardata.model.relationship.ColumnRelationshipImpl;

public abstract class StatefulBaseColumn
extends Column {
    private static final long serialVersionUID = -8722122712089071970L;
    private String label;
    private Optional<String> name = Optional.absent();
    private DataType dataType;
    private Optional<ColumnRelationshipImpl> relationship = Optional.absent();
    private ColumnType columnType;

    public StatefulBaseColumn(String label, String name, DataType dataType, ColumnRelationshipImpl relationship, ColumnType columnType) {
        if (label == null || label.isEmpty()) {
            throw new IllegalArgumentException("label cannot be null or empty");
        }
        if (dataType == null) {
            throw new IllegalArgumentException("DataType cannot be null");
        }
        this.label = label;
        this.dataType = dataType;
        this.name = Optional.fromNullable((Object)name);
        this.relationship = Optional.fromNullable((Object)relationship);
        this.columnType = columnType;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public void setLabel(String label) {
        this.label = label;
    }

    @Override
    public boolean hasName() {
        return this.name.isPresent();
    }

    @Override
    public String getName() {
        return (String)this.name.get();
    }

    @Override
    public DataType getDataType() {
        return this.dataType;
    }

    @Override
    public boolean hasRelationship() {
        return this.relationship.isPresent();
    }

    @Override
    public ColumnRelationship getRelationship() {
        return (ColumnRelationship)this.relationship.get();
    }

    @Override
    public ColumnType getColumnType() {
        return this.columnType;
    }

    @Override
    public void setName(String name) {
        this.name = Optional.of((Object)name);
    }
}

